rule win_freenki_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.freenki."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.freenki"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff75e4 ff15???????? 85c0 7920 8b45e4 50 8b08 }
            // n = 7, score = 200
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7920                 | jns                 0x22
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   50                   | push                eax
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_1 = { 89b5e4edffff 33c0 c785c0edffff00000000 50 51 8d8dccedffff c785e0edffff07000000 }
            // n = 7, score = 200
            //   89b5e4edffff         | mov                 dword ptr [ebp - 0x121c], esi
            //   33c0                 | xor                 eax, eax
            //   c785c0edffff00000000     | mov    dword ptr [ebp - 0x1240], 0
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8d8dccedffff         | lea                 ecx, [ebp - 0x1234]
            //   c785e0edffff07000000     | mov    dword ptr [ebp - 0x1220], 7

        $sequence_2 = { 56 e8???????? 8b8d60ffffff 8bf8 8b45f0 83c404 8930 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b8d60ffffff         | mov                 ecx, dword ptr [ebp - 0xa0]
            //   8bf8                 | mov                 edi, eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   83c404               | add                 esp, 4
            //   8930                 | mov                 dword ptr [eax], esi

        $sequence_3 = { 8bf8 83c404 85ff 0f84e4000000 6804010000 57 }
            // n = 6, score = 200
            //   8bf8                 | mov                 edi, eax
            //   83c404               | add                 esp, 4
            //   85ff                 | test                edi, edi
            //   0f84e4000000         | je                  0xea
            //   6804010000           | push                0x104
            //   57                   | push                edi

        $sequence_4 = { 51 8d4dc0 c745e400000000 e8???????? c745fc00000000 }
            // n = 5, score = 200
            //   51                   | push                ecx
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   e8????????           |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_5 = { 0fb78194f74100 8d4902 6689840deafbffff 6685c0 75e9 56 }
            // n = 6, score = 200
            //   0fb78194f74100       | movzx               eax, word ptr [ecx + 0x41f794]
            //   8d4902               | lea                 ecx, [ecx + 2]
            //   6689840deafbffff     | mov                 word ptr [ebp + ecx - 0x416], ax
            //   6685c0               | test                ax, ax
            //   75e9                 | jne                 0xffffffeb
            //   56                   | push                esi

        $sequence_6 = { c745c000000000 c745c400000000 c745c800000000 ff15???????? 898554ffffff 57 85c0 }
            // n = 7, score = 200
            //   c745c000000000       | mov                 dword ptr [ebp - 0x40], 0
            //   c745c400000000       | mov                 dword ptr [ebp - 0x3c], 0
            //   c745c800000000       | mov                 dword ptr [ebp - 0x38], 0
            //   ff15????????         |                     
            //   898554ffffff         | mov                 dword ptr [ebp - 0xac], eax
            //   57                   | push                edi
            //   85c0                 | test                eax, eax

        $sequence_7 = { 0bc8 51 53 e8???????? 8bd8 83c408 85db }
            // n = 7, score = 200
            //   0bc8                 | or                  ecx, eax
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   83c408               | add                 esp, 8
            //   85db                 | test                ebx, ebx

        $sequence_8 = { c3 56 57 53 ff75f4 ff75f8 }
            // n = 6, score = 200
            //   c3                   | ret                 
            //   56                   | push                esi
            //   57                   | push                edi
            //   53                   | push                ebx
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_9 = { 83c202 6685c0 75f5 2bd1 8d8df8deffff d1fa 03d2 }
            // n = 7, score = 200
            //   83c202               | add                 edx, 2
            //   6685c0               | test                ax, ax
            //   75f5                 | jne                 0xfffffff7
            //   2bd1                 | sub                 edx, ecx
            //   8d8df8deffff         | lea                 ecx, [ebp - 0x2108]
            //   d1fa                 | sar                 edx, 1
            //   03d2                 | add                 edx, edx

    condition:
        7 of them and filesize < 327680
}