rule win_friedex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.friedex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.friedex"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 85c0 7403 53 ffd0 6880000000 33db }
            // n = 7, score = 800
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5
            //   53                   | push                ebx
            //   ffd0                 | call                eax
            //   6880000000           | push                0x80
            //   33db                 | xor                 ebx, ebx

        $sequence_1 = { 5f 5e 5d 5b 59 c20400 8b4c2404 }
            // n = 7, score = 800
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   59                   | pop                 ecx
            //   c20400               | ret                 4
            //   8b4c2404             | mov                 ecx, dword ptr [esp + 4]

        $sequence_2 = { e8???????? 6a2f 8bc8 e8???????? 6a62 8bc8 e8???????? }
            // n = 7, score = 800
            //   e8????????           |                     
            //   6a2f                 | push                0x2f
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   6a62                 | push                0x62
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     

        $sequence_3 = { 55 56 57 6a2a 5f 6a3f 5b }
            // n = 7, score = 800
            //   55                   | push                ebp
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a2a                 | push                0x2a
            //   5f                   | pop                 edi
            //   6a3f                 | push                0x3f
            //   5b                   | pop                 ebx

        $sequence_4 = { 7410 6a3f 5a 663bfa }
            // n = 4, score = 800
            //   7410                 | je                  0x12
            //   6a3f                 | push                0x3f
            //   5a                   | pop                 edx
            //   663bfa               | cmp                 di, dx

        $sequence_5 = { 5e 5d c20c00 51 51 53 55 }
            // n = 7, score = 800
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   55                   | push                ebp

        $sequence_6 = { ff760c ffd0 8b442408 5e c20400 }
            // n = 5, score = 800
            //   ff760c               | push                dword ptr [esi + 0xc]
            //   ffd0                 | call                eax
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   5e                   | pop                 esi
            //   c20400               | ret                 4

        $sequence_7 = { 897c2414 5d eb16 0fb730 }
            // n = 4, score = 800
            //   897c2414             | mov                 dword ptr [esp + 0x14], edi
            //   5d                   | pop                 ebp
            //   eb16                 | jmp                 0x18
            //   0fb730               | movzx               esi, word ptr [eax]

        $sequence_8 = { 83c414 5b 5d c3 8b45f0 8b0c850440a500 8b55f8 }
            // n = 7, score = 100
            //   83c414               | add                 esp, 0x14
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b0c850440a500       | mov                 ecx, dword ptr [eax*4 + 0xa54004]
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_9 = { c7424004000000 c7424458270000 c7424800100100 8b7de4 c787cc00000000000000 c787c800000000000000 8945dc }
            // n = 7, score = 100
            //   c7424004000000       | mov                 dword ptr [edx + 0x40], 4
            //   c7424458270000       | mov                 dword ptr [edx + 0x44], 0x2758
            //   c7424800100100       | mov                 dword ptr [edx + 0x48], 0x11000
            //   8b7de4               | mov                 edi, dword ptr [ebp - 0x1c]
            //   c787cc00000000000000     | mov    dword ptr [edi + 0xcc], 0
            //   c787c800000000000000     | mov    dword ptr [edi + 0xc8], 0
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax

        $sequence_10 = { 8955dc e8???????? 8d0de830a500 890424 894c2404 e8???????? }
            // n = 6, score = 100
            //   8955dc               | mov                 dword ptr [ebp - 0x24], edx
            //   e8????????           |                     
            //   8d0de830a500         | lea                 ecx, [0xa530e8]
            //   890424               | mov                 dword ptr [esp], eax
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   e8????????           |                     

        $sequence_11 = { 8d155e30a500 83ec04 891424 8945e8 }
            // n = 4, score = 100
            //   8d155e30a500         | lea                 edx, [0xa5305e]
            //   83ec04               | sub                 esp, 4
            //   891424               | mov                 dword ptr [esp], edx
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_12 = { 55 89e5 8d055a23a500 5d c3 }
            // n = 5, score = 100
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   8d055a23a500         | lea                 eax, [0xa5235a]
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_13 = { 891424 894c2404 8945f8 e8???????? 8d0d4430a500 31d2 890c24 }
            // n = 7, score = 100
            //   891424               | mov                 dword ptr [esp], edx
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   e8????????           |                     
            //   8d0d4430a500         | lea                 ecx, [0xa53044]
            //   31d2                 | xor                 edx, edx
            //   890c24               | mov                 dword ptr [esp], ecx

        $sequence_14 = { 56 57 53 83ec54 8d055a23a500 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   53                   | push                ebx
            //   83ec54               | sub                 esp, 0x54
            //   8d055a23a500         | lea                 eax, [0xa5235a]

        $sequence_15 = { 890424 894c2404 e8???????? 8d0d4430a500 31d2 8b75f8 89462c }
            // n = 7, score = 100
            //   890424               | mov                 dword ptr [esp], eax
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   e8????????           |                     
            //   8d0d4430a500         | lea                 ecx, [0xa53044]
            //   31d2                 | xor                 edx, edx
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]
            //   89462c               | mov                 dword ptr [esi + 0x2c], eax

    condition:
        7 of them and filesize < 204800
}