rule win_frozenhill_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.frozenhill."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.frozenhill"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8be5 5d c3 1b9b0e10769b 0e 10d1 9b }
            // n = 7, score = 100
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   1b9b0e10769b         | sbb                 ebx, dword ptr [ebx - 0x6489eff2]
            //   0e                   | push                cs
            //   10d1                 | adc                 cl, dl
            //   9b                   | wait                

        $sequence_1 = { ff7508 8d85c8f7ffff 50 ff15???????? 3bf4 }
            // n = 5, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8d85c8f7ffff         | lea                 eax, [ebp - 0x838]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   3bf4                 | cmp                 esi, esp

        $sequence_2 = { 8d85f4feffff 3985e8feffff 7436 8b85e8feffff 0fbe08 83f95c 7428 }
            // n = 7, score = 100
            //   8d85f4feffff         | lea                 eax, [ebp - 0x10c]
            //   3985e8feffff         | cmp                 dword ptr [ebp - 0x118], eax
            //   7436                 | je                  0x38
            //   8b85e8feffff         | mov                 eax, dword ptr [ebp - 0x118]
            //   0fbe08               | movsx               ecx, byte ptr [eax]
            //   83f95c               | cmp                 ecx, 0x5c
            //   7428                 | je                  0x2a

        $sequence_3 = { 05???????? 50 e8???????? 83c404 ebda 5f 5e }
            // n = 7, score = 100
            //   05????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   ebda                 | jmp                 0xffffffdc
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_4 = { f3ab a1???????? 33c5 8945fc b9???????? e8???????? 6a73 }
            // n = 7, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   b9????????           |                     
            //   e8????????           |                     
            //   6a73                 | push                0x73

        $sequence_5 = { 8bf4 8b4508 8b4808 51 8b55f8 81c2300c0000 52 }
            // n = 7, score = 100
            //   8bf4                 | mov                 esi, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4808               | mov                 ecx, dword ptr [eax + 8]
            //   51                   | push                ecx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   81c2300c0000         | add                 edx, 0xc30
            //   52                   | push                edx

        $sequence_6 = { 8bf4 8d85f0fdffff 50 6804010000 ff15???????? 3bf4 }
            // n = 6, score = 100
            //   8bf4                 | mov                 esi, esp
            //   8d85f0fdffff         | lea                 eax, [ebp - 0x210]
            //   50                   | push                eax
            //   6804010000           | push                0x104
            //   ff15????????         |                     
            //   3bf4                 | cmp                 esi, esp

        $sequence_7 = { b874000000 66894586 b85c000000 66894588 b857000000 6689458a b869000000 }
            // n = 7, score = 100
            //   b874000000           | mov                 eax, 0x74
            //   66894586             | mov                 word ptr [ebp - 0x7a], ax
            //   b85c000000           | mov                 eax, 0x5c
            //   66894588             | mov                 word ptr [ebp - 0x78], ax
            //   b857000000           | mov                 eax, 0x57
            //   6689458a             | mov                 word ptr [ebp - 0x76], ax
            //   b869000000           | mov                 eax, 0x69

        $sequence_8 = { 5b 8b4df0 33cd e8???????? 81c480030000 }
            // n = 5, score = 100
            //   5b                   | pop                 ebx
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     
            //   81c480030000         | add                 esp, 0x380

        $sequence_9 = { 8945fc b9???????? e8???????? c745f400000000 c745e800000000 c745dc00000000 c745d000000000 }
            // n = 7, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   b9????????           |                     
            //   e8????????           |                     
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   c745dc00000000       | mov                 dword ptr [ebp - 0x24], 0
            //   c745d000000000       | mov                 dword ptr [ebp - 0x30], 0

    condition:
        7 of them and filesize < 2652160
}