rule win_fudmodule_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fudmodule."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fudmodule"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 660fb3e9 53 f6dd 660fbbe2 57 }
            // n = 5, score = 100
            //   660fb3e9             | dec                 eax
            //   53                   | mov                 esi, dword ptr [esp + 0x80]
            //   f6dd                 | dec                 eax
            //   660fbbe2             | mov                 ebx, dword ptr [esp + 0x78]
            //   57                   | dec                 eax

        $sequence_1 = { 4801e3 fec8 66c1cf03 d2e8 }
            // n = 4, score = 100
            //   4801e3               | xor                 bl, bl
            //   fec8                 | sbb                 bl, 0x4a
            //   66c1cf03             | add                 bl, ch
            //   d2e8                 | add                 ecx, 1

        $sequence_2 = { 498b8c24e0090000 e8???????? 4983bc24d809000000 488bb42480000000 488b5c2478 }
            // n = 5, score = 100
            //   498b8c24e0090000     | dec                 eax
            //   e8????????           |                     
            //   4983bc24d809000000     | lea    ecx, [esp + 0x58]
            //   488bb42480000000     | mov                 edx, dword ptr [esp + eax + 0x60]
            //   488b5c2478           | dec                 esp

        $sequence_3 = { f9 4801e3 e9???????? 660fbec2 58 e9???????? f5 }
            // n = 7, score = 100
            //   f9                   | dec                 eax
            //   4801e3               | add                 esp, 0x20
            //   e9????????           |                     
            //   660fbec2             | mov                 bl, 0x7a
            //   58                   | jne                 0xffff7361
            //   e9????????           |                     
            //   f5                   | sar                 si, cl

        $sequence_4 = { 41ffd5 85c0 782d 488bd6 }
            // n = 4, score = 100
            //   41ffd5               | inc                 ecx
            //   85c0                 | call                ebp
            //   782d                 | test                eax, eax
            //   488bd6               | js                  0x2f

        $sequence_5 = { 30db 80db4a 00eb 83c101 fec3 }
            // n = 5, score = 100
            //   30db                 | mov                 ecx, 8
            //   80db4a               | dec                 eax
            //   00eb                 | mov                 edx, ebx
            //   83c101               | dec                 eax
            //   fec3                 | mov                 ecx, eax

        $sequence_6 = { e8???????? 498bcc e8???????? 8d7514 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   498bcc               | dec                 eax
            //   e8????????           |                     
            //   8d7514               | mov                 edx, esi

        $sequence_7 = { 4963c3 488d4c2458 8b540460 4c8d440460 }
            // n = 4, score = 100
            //   4963c3               | lea                 edi, [ecx + eax]
            //   488d4c2458           | dec                 eax
            //   8b540460             | lea                 edx, [ebp - 0x50]
            //   4c8d440460           | dec                 eax

        $sequence_8 = { 0fb6c3 f6d0 0f9cc0 58 e9???????? }
            // n = 5, score = 100
            //   0fb6c3               | lea                 ecx, [ecx + 0x18]
            //   f6d0                 | mov                 word ptr [ebp - 0x48], ax
            //   0f9cc0               | mov                 eax, 0x33
            //   58                   | dec                 esp
            //   e9????????           |                     

        $sequence_9 = { 488bce e8???????? 85c0 7403 83cf08 488bce }
            // n = 6, score = 100
            //   488bce               | mov                 ecx, eax
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   7403                 | lea                 eax, [esp + 0x40]
            //   83cf08               | dec                 ecx
            //   488bce               | arpl                bx, ax

        $sequence_10 = { 488d3c01 ff15???????? 488d55b0 488bc8 488d442440 }
            // n = 5, score = 100
            //   488d3c01             | mov                 dword ptr [ebp - 0x48], 0x74756f52
            //   ff15????????         |                     
            //   488d55b0             | mov                 dword ptr [ebp - 0x44], 0x45656e69
            //   488bc8               | mov                 word ptr [ebp - 0x40], 0x78
            //   488d442440           | dec                 eax

        $sequence_11 = { 4883c420 b37a e9???????? 0f855b73ffff 66d3fe }
            // n = 5, score = 100
            //   4883c420             | mov                 dword ptr [esp + 0x20], edx
            //   b37a                 | dec                 esp
            //   e9????????           |                     
            //   0f855b73ffff         | lea                 eax, [esp + 0x30]
            //   66d3fe               | inc                 ecx

        $sequence_12 = { 488d8c246ed9e517 f5 f8 4889c3 488d3ced1b6cb3bd }
            // n = 5, score = 100
            //   488d8c246ed9e517     | mov                 eax, 0x45
            //   f5                   | xor                 ebx, ebx
            //   f8                   | dec                 eax
            //   4889c3               | mov                 edi, ecx
            //   488d3ced1b6cb3bd     | dec                 esp

        $sequence_13 = { 4889542420 4c8d442430 41b908000000 488bd3 488bc8 }
            // n = 5, score = 100
            //   4889542420           | lea                 eax, [esp + eax + 0x60]
            //   4c8d442430           | dec                 eax
            //   41b908000000         | mov                 ecx, esi
            //   488bd3               | test                eax, eax
            //   488bc8               | je                  5

        $sequence_14 = { c745b073734e6f c745b474696679 c745b8526f7574 c745bc696e6545 66c745c07800 }
            // n = 5, score = 100
            //   c745b073734e6f       | dec                 ecx
            //   c745b474696679       | mov                 ecx, esp
            //   c745b8526f7574       | lea                 esi, [ebp + 0x14]
            //   c745bc696e6545       | mov                 dword ptr [ebp - 0x50], 0x6f4e7373
            //   66c745c07800         | mov                 dword ptr [ebp - 0x4c], 0x79666974

        $sequence_15 = { fecb 4889e8 b377 b301 660fa3d2 0fbae207 }
            // n = 6, score = 100
            //   fecb                 | lea                 eax, [ebp - 0x50]
            //   4889e8               | btr                 cx, bp
            //   b377                 | push                ebx
            //   b301                 | neg                 ch
            //   660fa3d2             | btc                 dx, sp
            //   0fbae207             | push                edi

    condition:
        7 of them and filesize < 795648
}