rule win_fullmetal_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fullmetal."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fullmetal"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 90 8b4714 90 c1e80d }
            // n = 4, score = 100
            //   90                   | mov                 eax, dword ptr [ecx + ebp*8 + 0x44a40]
            //   8b4714               | dec                 edx
            //   90                   | mov                 eax, dword ptr [eax + edi*8 + 0x28]
            //   c1e80d               | dec                 eax

        $sequence_1 = { 488b05???????? 488d4de0 4d63c8 488bd3 4c8d8300010000 }
            // n = 5, score = 100
            //   488b05????????       |                     
            //   488d4de0             | and                 eax, 0x3f
            //   4d63c8               | dec                 esp
            //   488bd3               | lea                 edi, [eax + eax*8]
            //   4c8d8300010000       | dec                 edx

        $sequence_2 = { e9???????? 488d1580960200 488bcb ff15???????? }
            // n = 4, score = 100
            //   e9????????           |                     
            //   488d1580960200       | cmp                 dword ptr [ebx + esi*2], ebp
            //   488bcb               | jne                 0xfffffff8
            //   ff15????????         |                     

        $sequence_3 = { 85c0 7918 488d542420 488d0dc0b60200 }
            // n = 4, score = 100
            //   85c0                 | dec                 eax
            //   7918                 | lea                 edx, [0x29680]
            //   488d542420           | dec                 eax
            //   488d0dc0b60200       | mov                 ecx, ebx

        $sequence_4 = { 83e03f 4c8d3cc0 4a8b84e9404a0400 4a8b44f828 488945e7 458be1 }
            // n = 6, score = 100
            //   83e03f               | test                eax, eax
            //   4c8d3cc0             | jns                 0x1c
            //   4a8b84e9404a0400     | dec                 eax
            //   4a8b44f828           | lea                 edx, [esp + 0x20]
            //   488945e7             | dec                 eax
            //   458be1               | lea                 ecx, [0x2b6c0]

        $sequence_5 = { 85c0 7560 49ffc6 6646392c73 75f6 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   7560                 | jne                 0x62
            //   49ffc6               | dec                 ecx
            //   6646392c73           | inc                 esi
            //   75f6                 | inc                 si

        $sequence_6 = { eb20 bffdffffff 488b9424c8000000 488d0d2bc30200 4883c212 }
            // n = 5, score = 100
            //   eb20                 | lea                 ecx, [ebp - 0x20]
            //   bffdffffff           | dec                 ebp
            //   488b9424c8000000     | arpl                ax, cx
            //   488d0d2bc30200       | dec                 eax
            //   4883c212             | mov                 edx, ebx

        $sequence_7 = { 415e c3 8bc1 488d0df7990200 }
            // n = 4, score = 100
            //   415e                 | mov                 dword ptr [ebp - 0x19], eax
            //   c3                   | inc                 ebp
            //   8bc1                 | mov                 esp, ecx
            //   488d0df7990200       | dec                 eax

    condition:
        7 of them and filesize < 733184
}