rule win_furtim_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.furtim."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.furtim"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c3 55 8bec 83ec68 53 56 68???????? }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec68               | sub                 esp, 0x68
            //   53                   | push                ebx
            //   56                   | push                esi
            //   68????????           |                     

        $sequence_1 = { 85c0 7413 8b4c2424 8bd1 2bd6 8a12 8811 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7413                 | je                  0x15
            //   8b4c2424             | mov                 ecx, dword ptr [esp + 0x24]
            //   8bd1                 | mov                 edx, ecx
            //   2bd6                 | sub                 edx, esi
            //   8a12                 | mov                 dl, byte ptr [edx]
            //   8811                 | mov                 byte ptr [ecx], dl

        $sequence_2 = { 55 8bec 8b4508 ff34c5d0404100 ff15???????? 5d c3 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   ff34c5d0404100       | push                dword ptr [eax*8 + 0x4140d0]
            //   ff15????????         |                     
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_3 = { 5e 5b c9 c20800 56 8bf1 ff96d4060000 }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c20800               | ret                 8
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   ff96d4060000         | call                dword ptr [esi + 0x6d4]

        $sequence_4 = { 8bf8 68???????? 57 ff961c070000 83c40c 6a0b 57 }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   68????????           |                     
            //   57                   | push                edi
            //   ff961c070000         | call                dword ptr [esi + 0x71c]
            //   83c40c               | add                 esp, 0xc
            //   6a0b                 | push                0xb
            //   57                   | push                edi

        $sequence_5 = { 33db 895de8 8d7dec ab ab ab 8d45fc }
            // n = 7, score = 100
            //   33db                 | xor                 ebx, ebx
            //   895de8               | mov                 dword ptr [ebp - 0x18], ebx
            //   8d7dec               | lea                 edi, [ebp - 0x14]
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_6 = { ff969c020000 85c0 0f850d010000 33db 399e08060000 0f84f7000000 33c0 }
            // n = 7, score = 100
            //   ff969c020000         | call                dword ptr [esi + 0x29c]
            //   85c0                 | test                eax, eax
            //   0f850d010000         | jne                 0x113
            //   33db                 | xor                 ebx, ebx
            //   399e08060000         | cmp                 dword ptr [esi + 0x608], ebx
            //   0f84f7000000         | je                  0xfd
            //   33c0                 | xor                 eax, eax

        $sequence_7 = { 895df4 ff9660060000 85c0 7532 385dfc 742d 0fb645fc }
            // n = 7, score = 100
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx
            //   ff9660060000         | call                dword ptr [esi + 0x660]
            //   85c0                 | test                eax, eax
            //   7532                 | jne                 0x34
            //   385dfc               | cmp                 byte ptr [ebp - 4], bl
            //   742d                 | je                  0x2f
            //   0fb645fc             | movzx               eax, byte ptr [ebp - 4]

        $sequence_8 = { 7405 8bce ff5614 53 53 56 ffb640070000 }
            // n = 7, score = 100
            //   7405                 | je                  7
            //   8bce                 | mov                 ecx, esi
            //   ff5614               | call                dword ptr [esi + 0x14]
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   56                   | push                esi
            //   ffb640070000         | push                dword ptr [esi + 0x740]

        $sequence_9 = { 56 53 ffb360020000 8975fc 56 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   53                   | push                ebx
            //   ffb360020000         | push                dword ptr [ebx + 0x260]
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   56                   | push                esi

    condition:
        7 of them and filesize < 622592
}