rule win_fusiondrive_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fusiondrive."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fusiondrive"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33db 4c8d35e14effff 4885db 750d 488bc7 498784f660de0100 eb1e }
            // n = 7, score = 100
            //   33db                 | ret                 
            //   4c8d35e14effff       | dec                 eax
            //   4885db               | sub                 esp, 0x28
            //   750d                 | dec                 eax
            //   488bc7               | test                eax, eax
            //   498784f660de0100     | jne                 0x85c
            //   eb1e                 | dec                 eax

        $sequence_1 = { 4883ec28 488d0d75c60100 e8???????? 488d0da9f50000 4883c428 e9???????? }
            // n = 6, score = 100
            //   4883ec28             | xor                 ebx, ebx
            //   488d0d75c60100       | dec                 eax
            //   e8????????           |                     
            //   488d0da9f50000       | lea                 edx, [0x14619]
            //   4883c428             | inc                 ebp
            //   e9????????           |                     

        $sequence_2 = { 660f6f05???????? f30f7f442470 66c745806557 c6458200 488d542470 488bc8 ff15???????? }
            // n = 7, score = 100
            //   660f6f05????????     |                     
            //   f30f7f442470         | mov                 edx, edi
            //   66c745806557         | dec                 eax
            //   c6458200             | mov                 ecx, ebx
            //   488d542470           | dec                 eax
            //   488bc8               | mov                 ecx, eax
            //   ff15????????         |                     

        $sequence_3 = { 488dac2450feffff 4881ecb0020000 488b05???????? 4833c4 488985a0010000 4032ff }
            // n = 6, score = 100
            //   488dac2450feffff     | jne                 0x5d9
            //   4881ecb0020000       | inc                 ecx
            //   488b05????????       |                     
            //   4833c4               | mov                 eax, dword ptr [esp]
            //   488985a0010000       | dec                 eax
            //   4032ff               | mov                 ecx, eax

        $sequence_4 = { 4883c907 33ed 483bcf 7606 }
            // n = 4, score = 100
            //   4883c907             | dec                 esp
            //   33ed                 | sub                 ecx, eax
            //   483bcf               | inc                 ebp
            //   7606                 | mov                 ebx, dword ptr [ecx - 4]

        $sequence_5 = { 41894018 0fb60a 83e10f 4a0fbe8409a8150100 428a8c09b8150100 482bd0 8b42fc }
            // n = 7, score = 100
            //   41894018             | jmp                 0x318
            //   0fb60a               | dec                 ebp
            //   83e10f               | mov                 edi, dword ptr [edi + esi*8 + 0x12458]
            //   4a0fbe8409a8150100     | xor    edx, edx
            //   428a8c09b8150100     | dec                 ecx
            //   482bd0               | mov                 ecx, edi
            //   8b42fc               | inc                 ecx

        $sequence_6 = { e8???????? 488d0da9f50000 4883c428 e9???????? 4053 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   488d0da9f50000       | mov                 ecx, edi
            //   4883c428             | dec                 eax
            //   e9????????           |                     
            //   4053                 | test                eax, eax

        $sequence_7 = { 488d5202 83f902 72ea c605????????00 }
            // n = 4, score = 100
            //   488d5202             | mov                 dword ptr [eax + 0x18], edi
            //   83f902               | dec                 eax
            //   72ea                 | mov                 dword ptr [eax + 0x20], edi
            //   c605????????00       |                     

        $sequence_8 = { 776a e8???????? 85c0 7428 85db 7524 488d0d92a30100 }
            // n = 7, score = 100
            //   776a                 | rep stosd           dword ptr es:[edi], eax
            //   e8????????           |                     
            //   85c0                 | inc                 cx
            //   7428                 | mov                 dword ptr [esi + esi*2], ebp
            //   85db                 | dec                 ecx
            //   7524                 | cmp                 edi, 8
            //   488d0d92a30100       | je                  0x9d

        $sequence_9 = { 4c8d05e3e90000 83e23f 488bcf 48c1f906 488d14d2 498b0cc8 c644d13800 }
            // n = 7, score = 100
            //   4c8d05e3e90000       | cmovae              ecx, edi
            //   83e23f               | dec                 eax
            //   488bcf               | lea                 edi, [esp + 0x20]
            //   48c1f906             | dec                 esp
            //   488d14d2             | mov                 esp, dword ptr [esp + 0x38]
            //   498b0cc8             | dec                 ecx
            //   c644d13800           | cmp                 esp, 8

    condition:
        7 of them and filesize < 290816
}