rule win_fuwuqidrama_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fuwuqidrama."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fuwuqidrama"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 8bcf e8???????? 8d9424d4020000 6a04 52 8bcf }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8d9424d4020000       | lea                 edx, [esp + 0x2d4]
            //   6a04                 | push                4
            //   52                   | push                edx
            //   8bcf                 | mov                 ecx, edi

        $sequence_1 = { 83c10c 48 894c2434 89442418 75bd 8b742444 8b06 }
            // n = 7, score = 100
            //   83c10c               | add                 ecx, 0xc
            //   48                   | dec                 eax
            //   894c2434             | mov                 dword ptr [esp + 0x34], ecx
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   75bd                 | jne                 0xffffffbf
            //   8b742444             | mov                 esi, dword ptr [esp + 0x44]
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_2 = { c1fa05 8bc2 c1e81f 03d0 895508 8d4d08 6a04 }
            // n = 7, score = 100
            //   c1fa05               | sar                 edx, 5
            //   8bc2                 | mov                 eax, edx
            //   c1e81f               | shr                 eax, 0x1f
            //   03d0                 | add                 edx, eax
            //   895508               | mov                 dword ptr [ebp + 8], edx
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   6a04                 | push                4

        $sequence_3 = { 33d2 eb16 8b4e08 2bc8 b815024d21 f7e9 c1fa06 }
            // n = 7, score = 100
            //   33d2                 | xor                 edx, edx
            //   eb16                 | jmp                 0x18
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   2bc8                 | sub                 ecx, eax
            //   b815024d21           | mov                 eax, 0x214d0215
            //   f7e9                 | imul                ecx
            //   c1fa06               | sar                 edx, 6

        $sequence_4 = { fec8 5f 8841ff 8bc5 5e 5d 5b }
            // n = 7, score = 100
            //   fec8                 | dec                 al
            //   5f                   | pop                 edi
            //   8841ff               | mov                 byte ptr [ecx - 1], al
            //   8bc5                 | mov                 eax, ebp
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx

        $sequence_5 = { b90b000000 8bf0 8bfa 83c02c f3a5 8b4c2420 83c22c }
            // n = 7, score = 100
            //   b90b000000           | mov                 ecx, 0xb
            //   8bf0                 | mov                 esi, eax
            //   8bfa                 | mov                 edi, edx
            //   83c02c               | add                 eax, 0x2c
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   83c22c               | add                 edx, 0x2c

        $sequence_6 = { 23ee 8b742428 23f7 8bd9 0bee 8b74241c c1c305 }
            // n = 7, score = 100
            //   23ee                 | and                 ebp, esi
            //   8b742428             | mov                 esi, dword ptr [esp + 0x28]
            //   23f7                 | and                 esi, edi
            //   8bd9                 | mov                 ebx, ecx
            //   0bee                 | or                  ebp, esi
            //   8b74241c             | mov                 esi, dword ptr [esp + 0x1c]
            //   c1c305               | rol                 ebx, 5

        $sequence_7 = { 8db5f4000000 8d9d14010000 c744241800000000 e8???????? 8b442410 85c0 0f8c08010000 }
            // n = 7, score = 100
            //   8db5f4000000         | lea                 esi, [ebp + 0xf4]
            //   8d9d14010000         | lea                 ebx, [ebp + 0x114]
            //   c744241800000000     | mov                 dword ptr [esp + 0x18], 0
            //   e8????????           |                     
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   85c0                 | test                eax, eax
            //   0f8c08010000         | jl                  0x10e

        $sequence_8 = { 83c410 48 894720 53 ff15???????? 5f 5e }
            // n = 7, score = 100
            //   83c410               | add                 esp, 0x10
            //   48                   | dec                 eax
            //   894720               | mov                 dword ptr [edi + 0x20], eax
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_9 = { 03ee 8b742410 c1c71e 8db42ea1ebd96e 8b6930 33691c 33df }
            // n = 7, score = 100
            //   03ee                 | add                 ebp, esi
            //   8b742410             | mov                 esi, dword ptr [esp + 0x10]
            //   c1c71e               | rol                 edi, 0x1e
            //   8db42ea1ebd96e       | lea                 esi, [esi + ebp + 0x6ed9eba1]
            //   8b6930               | mov                 ebp, dword ptr [ecx + 0x30]
            //   33691c               | xor                 ebp, dword ptr [ecx + 0x1c]
            //   33df                 | xor                 ebx, edi

    condition:
        7 of them and filesize < 245760
}