rule win_fuxsocy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.fuxsocy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fuxsocy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b0d???????? e8???????? 8b4dfc e8???????? 46 3b35???????? 72c4 }
            // n = 7, score = 200
            //   8b0d????????         |                     
            //   e8????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   46                   | inc                 esi
            //   3b35????????         |                     
            //   72c4                 | jb                  0xffffffc6

        $sequence_1 = { 51 51 51 51 f7d8 51 }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   f7d8                 | neg                 eax
            //   51                   | push                ecx

        $sequence_2 = { 50 6a01 53 ff15???????? 85c0 756e 395c2414 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   756e                 | jne                 0x70
            //   395c2414             | cmp                 dword ptr [esp + 0x14], ebx

        $sequence_3 = { 8b08 ff5108 8b45e4 5f 5e c9 c3 }
            // n = 7, score = 200
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5108               | call                dword ptr [ecx + 8]
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_4 = { ff74241c 8bda 894c2414 ff15???????? 8b7c2418 8be8 8b17 }
            // n = 7, score = 200
            //   ff74241c             | push                dword ptr [esp + 0x1c]
            //   8bda                 | mov                 ebx, edx
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   ff15????????         |                     
            //   8b7c2418             | mov                 edi, dword ptr [esp + 0x18]
            //   8be8                 | mov                 ebp, eax
            //   8b17                 | mov                 edx, dword ptr [edi]

        $sequence_5 = { 50 8d44241c 50 6a00 6a07 6a00 ff742424 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d44241c             | lea                 eax, [esp + 0x1c]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a07                 | push                7
            //   6a00                 | push                0
            //   ff742424             | push                dword ptr [esp + 0x24]

        $sequence_6 = { 8954240c 85ff 7474 8b4f04 55 8d54240c e8???????? }
            // n = 7, score = 200
            //   8954240c             | mov                 dword ptr [esp + 0xc], edx
            //   85ff                 | test                edi, edi
            //   7474                 | je                  0x76
            //   8b4f04               | mov                 ecx, dword ptr [edi + 4]
            //   55                   | push                ebp
            //   8d54240c             | lea                 edx, [esp + 0xc]
            //   e8????????           |                     

        $sequence_7 = { 8b45fc 6a5c 5a 66891448 }
            // n = 4, score = 200
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   6a5c                 | push                0x5c
            //   5a                   | pop                 edx
            //   66891448             | mov                 word ptr [eax + ecx*2], dx

        $sequence_8 = { 83c102 e8???????? 8b16 8b4e1c 8944d104 ff06 }
            // n = 6, score = 200
            //   83c102               | add                 ecx, 2
            //   e8????????           |                     
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   8b4e1c               | mov                 ecx, dword ptr [esi + 0x1c]
            //   8944d104             | mov                 dword ptr [ecx + edx*8 + 4], eax
            //   ff06                 | inc                 dword ptr [esi]

        $sequence_9 = { 8954241c 8be9 8364241000 8364241800 8364242400 8d442424 50 }
            // n = 7, score = 200
            //   8954241c             | mov                 dword ptr [esp + 0x1c], edx
            //   8be9                 | mov                 ebp, ecx
            //   8364241000           | and                 dword ptr [esp + 0x10], 0
            //   8364241800           | and                 dword ptr [esp + 0x18], 0
            //   8364242400           | and                 dword ptr [esp + 0x24], 0
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 131072
}