rule win_gameover_p2p_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gameover_p2p."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gameover_p2p"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 88442413 0fb6c0 8944241c 8a80007f3902 0fb6c0 3bc8 }
            // n = 6, score = 100
            //   88442413             | mov                 byte ptr [esp + 0x13], al
            //   0fb6c0               | movzx               eax, al
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   8a80007f3902         | mov                 al, byte ptr [eax + 0x2397f00]
            //   0fb6c0               | movzx               eax, al
            //   3bc8                 | cmp                 ecx, eax

        $sequence_1 = { 8d55ee 33c9 e8???????? ba???????? 6a2e 58 668945ec }
            // n = 7, score = 100
            //   8d55ee               | lea                 edx, [ebp - 0x12]
            //   33c9                 | xor                 ecx, ecx
            //   e8????????           |                     
            //   ba????????           |                     
            //   6a2e                 | push                0x2e
            //   58                   | pop                 eax
            //   668945ec             | mov                 word ptr [ebp - 0x14], ax

        $sequence_2 = { 33c0 e9???????? 6a74 59 e8???????? 8bf8 85ff }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   6a74                 | push                0x74
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi

        $sequence_3 = { 8b8684000000 8d0440 03c0 0fb78c008a183902 03c0 898e80000000 0fb79088183902 }
            // n = 7, score = 100
            //   8b8684000000         | mov                 eax, dword ptr [esi + 0x84]
            //   8d0440               | lea                 eax, [eax + eax*2]
            //   03c0                 | add                 eax, eax
            //   0fb78c008a183902     | movzx               ecx, word ptr [eax + eax + 0x239188a]
            //   03c0                 | add                 eax, eax
            //   898e80000000         | mov                 dword ptr [esi + 0x80], ecx
            //   0fb79088183902       | movzx               edx, word ptr [eax + 0x2391888]

        $sequence_4 = { 895108 6bd20c 83c104 e8???????? c20400 f644240401 }
            // n = 6, score = 100
            //   895108               | mov                 dword ptr [ecx + 8], edx
            //   6bd20c               | imul                edx, edx, 0xc
            //   83c104               | add                 ecx, 4
            //   e8????????           |                     
            //   c20400               | ret                 4
            //   f644240401           | test                byte ptr [esp + 4], 1

        $sequence_5 = { 3d02010000 0f85e0000000 8d7dce 6800020000 8d44241c 50 8d8424b0060000 }
            // n = 7, score = 100
            //   3d02010000           | cmp                 eax, 0x102
            //   0f85e0000000         | jne                 0xe6
            //   8d7dce               | lea                 edi, [ebp - 0x32]
            //   6800020000           | push                0x200
            //   8d44241c             | lea                 eax, [esp + 0x1c]
            //   50                   | push                eax
            //   8d8424b0060000       | lea                 eax, [esp + 0x6b0]

        $sequence_6 = { e8???????? 33d2 b9ff000000 f7f1 6a00 56 8bcf }
            // n = 7, score = 100
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   b9ff000000           | mov                 ecx, 0xff
            //   f7f1                 | div                 ecx
            //   6a00                 | push                0
            //   56                   | push                esi
            //   8bcf                 | mov                 ecx, edi

        $sequence_7 = { ff15???????? 8bf0 89742410 83feff 7478 8d442414 50 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   89742410             | mov                 dword ptr [esp + 0x10], esi
            //   83feff               | cmp                 esi, -1
            //   7478                 | je                  0x7a
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax

        $sequence_8 = { 8a0408 3204f598613902 32c2 42 880439 663b14f59a613902 }
            // n = 6, score = 100
            //   8a0408               | mov                 al, byte ptr [eax + ecx]
            //   3204f598613902       | xor                 al, byte ptr [esi*8 + 0x2396198]
            //   32c2                 | xor                 al, dl
            //   42                   | inc                 edx
            //   880439               | mov                 byte ptr [ecx + edi], al
            //   663b14f59a613902     | cmp                 dx, word ptr [esi*8 + 0x239619a]

        $sequence_9 = { 50 8d442448 85ed 8b6c2444 0f45c8 51 ff742430 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d442448             | lea                 eax, [esp + 0x48]
            //   85ed                 | test                ebp, ebp
            //   8b6c2444             | mov                 ebp, dword ptr [esp + 0x44]
            //   0f45c8               | cmovne              ecx, eax
            //   51                   | push                ecx
            //   ff742430             | push                dword ptr [esp + 0x30]

    condition:
        7 of them and filesize < 598016
}