rule win_gamotrol_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gamotrol."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gamotrol"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 90 55 90 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   90                   | nop                 
            //   55                   | push                ebp
            //   90                   | nop                 

        $sequence_1 = { eb82 55 8bec 83ec20 56 33f6 39750c }
            // n = 7, score = 100
            //   eb82                 | jmp                 0xffffff84
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec20               | sub                 esp, 0x20
            //   56                   | push                esi
            //   33f6                 | xor                 esi, esi
            //   39750c               | cmp                 dword ptr [ebp + 0xc], esi

        $sequence_2 = { 83c40b 83ec0b 68b4c2ffff 83c410 83c4f0 6aff 68???????? }
            // n = 7, score = 100
            //   83c40b               | add                 esp, 0xb
            //   83ec0b               | sub                 esp, 0xb
            //   68b4c2ffff           | push                0xffffc2b4
            //   83c410               | add                 esp, 0x10
            //   83c4f0               | add                 esp, -0x10
            //   6aff                 | push                -1
            //   68????????           |                     

        $sequence_3 = { c1c804 8945fc 61 8b45f4 }
            // n = 4, score = 100
            //   c1c804               | ror                 eax, 4
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   61                   | popal               
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_4 = { 83ec0b 83c40f 83c4f1 83c45b 83ec5b 90 90 }
            // n = 7, score = 100
            //   83ec0b               | sub                 esp, 0xb
            //   83c40f               | add                 esp, 0xf
            //   83c4f1               | add                 esp, -0xf
            //   83c45b               | add                 esp, 0x5b
            //   83ec5b               | sub                 esp, 0x5b
            //   90                   | nop                 
            //   90                   | nop                 

        $sequence_5 = { cc 8b442404 a3???????? c3 8b442404 a3???????? a3???????? }
            // n = 7, score = 100
            //   cc                   | int3                
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   a3????????           |                     
            //   c3                   | ret                 
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   a3????????           |                     
            //   a3????????           |                     

        $sequence_6 = { 5d 85c0 7709 33c0 5f 5e }
            // n = 6, score = 100
            //   5d                   | pop                 ebp
            //   85c0                 | test                eax, eax
            //   7709                 | ja                  0xb
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_7 = { 8945e4 90 90 55 8bec }
            // n = 5, score = 100
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   90                   | nop                 
            //   90                   | nop                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_8 = { 81ec00020000 8d6c24fc a1???????? 33c5 898500020000 6a0c b8???????? }
            // n = 7, score = 100
            //   81ec00020000         | sub                 esp, 0x200
            //   8d6c24fc             | lea                 ebp, [esp - 4]
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   898500020000         | mov                 dword ptr [ebp + 0x200], eax
            //   6a0c                 | push                0xc
            //   b8????????           |                     

        $sequence_9 = { 6aff 6a00 68???????? 6a00 ff15???????? }
            // n = 5, score = 100
            //   6aff                 | push                -1
            //   6a00                 | push                0
            //   68????????           |                     
            //   6a00                 | push                0
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 376832
}