rule win_gandcrab_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gandcrab."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gandcrab"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 03c3 8d5e04 03d8 837f4800 741b ff7750 ff15???????? }
            // n = 7, score = 2100
            //   03c3                 | add                 eax, ebx
            //   8d5e04               | lea                 ebx, [esi + 4]
            //   03d8                 | add                 ebx, eax
            //   837f4800             | cmp                 dword ptr [edi + 0x48], 0
            //   741b                 | je                  0x1d
            //   ff7750               | push                dword ptr [edi + 0x50]
            //   ff15????????         |                     

        $sequence_1 = { ff777c ff15???????? ff7778 8bf0 ff15???????? }
            // n = 5, score = 2100
            //   ff777c               | push                dword ptr [edi + 0x7c]
            //   ff15????????         |                     
            //   ff7778               | push                dword ptr [edi + 0x78]
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     

        $sequence_2 = { ff15???????? ff7728 8bf0 ff15???????? 03c3 8d5e04 }
            // n = 6, score = 2100
            //   ff15????????         |                     
            //   ff7728               | push                dword ptr [edi + 0x28]
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   03c3                 | add                 eax, ebx
            //   8d5e04               | lea                 ebx, [esi + 4]

        $sequence_3 = { ff15???????? 03c3 8d5e04 03d8 837f3000 }
            // n = 5, score = 2100
            //   ff15????????         |                     
            //   03c3                 | add                 eax, ebx
            //   8d5e04               | lea                 ebx, [esi + 4]
            //   03d8                 | add                 ebx, eax
            //   837f3000             | cmp                 dword ptr [edi + 0x30], 0

        $sequence_4 = { ff15???????? ff7734 8bf0 ff15???????? 03c3 8d5e04 }
            // n = 6, score = 2100
            //   ff15????????         |                     
            //   ff7734               | push                dword ptr [edi + 0x34]
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   03c3                 | add                 eax, ebx
            //   8d5e04               | lea                 ebx, [esi + 4]

        $sequence_5 = { 03c3 8d5e04 03d8 837f3000 741b }
            // n = 5, score = 2100
            //   03c3                 | add                 eax, ebx
            //   8d5e04               | lea                 ebx, [esi + 4]
            //   03d8                 | add                 ebx, eax
            //   837f3000             | cmp                 dword ptr [edi + 0x30], 0
            //   741b                 | je                  0x1d

        $sequence_6 = { 5f 66894c46fe 8bc6 5e }
            // n = 4, score = 2100
            //   5f                   | pop                 edi
            //   66894c46fe           | mov                 word ptr [esi + eax*2 - 2], cx
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi

        $sequence_7 = { ff15???????? ff7778 8bf0 ff15???????? 03c3 }
            // n = 5, score = 2100
            //   ff15????????         |                     
            //   ff7778               | push                dword ptr [edi + 0x78]
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   03c3                 | add                 eax, ebx

        $sequence_8 = { ff15???????? 03c3 8d5e04 03d8 837f3c00 741b ff7744 }
            // n = 7, score = 2100
            //   ff15????????         |                     
            //   03c3                 | add                 eax, ebx
            //   8d5e04               | lea                 ebx, [esi + 4]
            //   03d8                 | add                 ebx, eax
            //   837f3c00             | cmp                 dword ptr [edi + 0x3c], 0
            //   741b                 | je                  0x1d
            //   ff7744               | push                dword ptr [edi + 0x44]

        $sequence_9 = { 741b ff777c ff15???????? ff7778 8bf0 }
            // n = 5, score = 2100
            //   741b                 | je                  0x1d
            //   ff777c               | push                dword ptr [edi + 0x7c]
            //   ff15????????         |                     
            //   ff7778               | push                dword ptr [edi + 0x78]
            //   8bf0                 | mov                 esi, eax

    condition:
        7 of them and filesize < 1024000
}