rule win_gcleaner_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gcleaner."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gcleaner"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 6a04 8d85f0feffff 50 56 ff15???????? 85c0 }
            // n = 7, score = 700
            //   50                   | push                eax
            //   6a04                 | push                4
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_1 = { 5e c9 c3 53 ff7518 }
            // n = 5, score = 700
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   ff7518               | push                dword ptr [ebp + 0x18]

        $sequence_2 = { 8035????????2e 8035????????2e 8035????????2e 8035????????2e 8035????????2e }
            // n = 5, score = 700
            //   8035????????2e       |                     
            //   8035????????2e       |                     
            //   8035????????2e       |                     
            //   8035????????2e       |                     
            //   8035????????2e       |                     

        $sequence_3 = { 8bf8 83c40c 83ffff 743b 3bf7 }
            // n = 5, score = 700
            //   8bf8                 | mov                 edi, eax
            //   83c40c               | add                 esp, 0xc
            //   83ffff               | cmp                 edi, -1
            //   743b                 | je                  0x3d
            //   3bf7                 | cmp                 esi, edi

        $sequence_4 = { 57 8bd0 c645fc03 8d4dc0 }
            // n = 4, score = 700
            //   57                   | push                edi
            //   8bd0                 | mov                 edx, eax
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]

        $sequence_5 = { 7505 c60600 ebe9 837d1000 7518 }
            // n = 5, score = 700
            //   7505                 | jne                 7
            //   c60600               | mov                 byte ptr [esi], 0
            //   ebe9                 | jmp                 0xffffffeb
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   7518                 | jne                 0x1a

        $sequence_6 = { 8bd0 c645fc02 8d4da8 e8???????? 57 8bd0 }
            // n = 6, score = 700
            //   8bd0                 | mov                 edx, eax
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   8d4da8               | lea                 ecx, [ebp - 0x58]
            //   e8????????           |                     
            //   57                   | push                edi
            //   8bd0                 | mov                 edx, eax

        $sequence_7 = { 8bd0 c645fc04 8d4dd8 e8???????? 83c410 8d4dc0 }
            // n = 6, score = 700
            //   8bd0                 | mov                 edx, eax
            //   c645fc04             | mov                 byte ptr [ebp - 4], 4
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]

        $sequence_8 = { 50 660fd685f8feffff e8???????? 83c40c 56 }
            // n = 5, score = 700
            //   50                   | push                eax
            //   660fd685f8feffff     | movq                qword ptr [ebp - 0x108], xmm0
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   56                   | push                esi

        $sequence_9 = { ebe9 837d1000 7518 c60600 e8???????? }
            // n = 5, score = 700
            //   ebe9                 | jmp                 0xffffffeb
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   7518                 | jne                 0x1a
            //   c60600               | mov                 byte ptr [esi], 0
            //   e8????????           |                     

    condition:
        7 of them and filesize < 540672
}