rule win_getmypass_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.getmypass."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.getmypass"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c404 85c0 0f8444010000 8b4508 50 e8???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   0f8444010000         | je                  0x14a
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_1 = { 3b4d10 7d12 8b550c 0355fc 8b4508 0345fc 8a08 }
            // n = 7, score = 200
            //   3b4d10               | cmp                 ecx, dword ptr [ebp + 0x10]
            //   7d12                 | jge                 0x14
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   0355fc               | add                 edx, dword ptr [ebp - 4]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0345fc               | add                 eax, dword ptr [ebp - 4]
            //   8a08                 | mov                 cl, byte ptr [eax]

        $sequence_2 = { 8b45e0 0fbe08 83f944 0f8535010000 837de400 750b 8b55e0 }
            // n = 7, score = 200
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   0fbe08               | movsx               ecx, byte ptr [eax]
            //   83f944               | cmp                 ecx, 0x44
            //   0f8535010000         | jne                 0x13b
            //   837de400             | cmp                 dword ptr [ebp - 0x1c], 0
            //   750b                 | jne                 0xd
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]

        $sequence_3 = { 55 8bec 83ec08 c745fc00000000 8d45fc 50 68???????? }
            // n = 7, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec08               | sub                 esp, 8
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_4 = { 55 8bec 83ec08 833d????????04 721d a1???????? }
            // n = 6, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec08               | sub                 esp, 8
            //   833d????????04       |                     
            //   721d                 | jb                  0x1f
            //   a1????????           |                     

        $sequence_5 = { 0f8400010000 837de400 750b 8b45e0 }
            // n = 4, score = 200
            //   0f8400010000         | je                  0x106
            //   837de400             | cmp                 dword ptr [ebp - 0x1c], 0
            //   750b                 | jne                 0xd
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]

        $sequence_6 = { 8b4d0c 51 e8???????? 83c40c 8d95d8f5ffff 52 8b4508 }
            // n = 7, score = 200
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d95d8f5ffff         | lea                 edx, [ebp - 0xa28]
            //   52                   | push                edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_7 = { 8b45fc 50 6a00 ff15???????? 8985f4fbffff }
            // n = 5, score = 200
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8985f4fbffff         | mov                 dword ptr [ebp - 0x40c], eax

        $sequence_8 = { 8a55f8 8811 ebe1 c745f400000000 8b45f4 8945ec }
            // n = 6, score = 200
            //   8a55f8               | mov                 dl, byte ptr [ebp - 8]
            //   8811                 | mov                 byte ptr [ecx], dl
            //   ebe1                 | jmp                 0xffffffe3
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

        $sequence_9 = { 83f944 0f85b4020000 837d9819 0f86aa020000 c745a400000000 8b55e0 83ea01 }
            // n = 7, score = 200
            //   83f944               | cmp                 ecx, 0x44
            //   0f85b4020000         | jne                 0x2ba
            //   837d9819             | cmp                 dword ptr [ebp - 0x68], 0x19
            //   0f86aa020000         | jbe                 0x2b0
            //   c745a400000000       | mov                 dword ptr [ebp - 0x5c], 0
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]
            //   83ea01               | sub                 edx, 1

    condition:
        7 of them and filesize < 49152
}