rule win_gh0sttimes_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gh0sttimes."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gh0sttimes"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bce 8bd6 8d85e0fdffff e8???????? 8b9dd8fdffff 56 }
            // n = 6, score = 800
            //   8bce                 | mov                 ecx, esi
            //   8bd6                 | mov                 edx, esi
            //   8d85e0fdffff         | lea                 eax, [ebp - 0x220]
            //   e8????????           |                     
            //   8b9dd8fdffff         | mov                 ebx, dword ptr [ebp - 0x228]
            //   56                   | push                esi

        $sequence_1 = { b804000000 8bcf 81f3d2b5a2c3 e8???????? }
            // n = 4, score = 800
            //   b804000000           | mov                 eax, 4
            //   8bcf                 | mov                 ecx, edi
            //   81f3d2b5a2c3         | xor                 ebx, 0xc3a2b5d2
            //   e8????????           |                     

        $sequence_2 = { ff15???????? 8b5604 895608 ba00040000 }
            // n = 4, score = 800
            //   ff15????????         |                     
            //   8b5604               | mov                 edx, dword ptr [esi + 4]
            //   895608               | mov                 dword ptr [esi + 8], edx
            //   ba00040000           | mov                 edx, 0x400

        $sequence_3 = { 894608 8b85e4fdffff 8b8de8fdffff 40 }
            // n = 4, score = 800
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   8b85e4fdffff         | mov                 eax, dword ptr [ebp - 0x21c]
            //   8b8de8fdffff         | mov                 ecx, dword ptr [ebp - 0x218]
            //   40                   | inc                 eax

        $sequence_4 = { 57 ff15???????? 8d443801 50 57 ff15???????? }
            // n = 6, score = 800
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8d443801             | lea                 eax, [eax + edi + 1]
            //   50                   | push                eax
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_5 = { 8b82ac000000 6a00 57 56 50 }
            // n = 5, score = 800
            //   8b82ac000000         | mov                 eax, dword ptr [edx + 0xac]
            //   6a00                 | push                0
            //   57                   | push                edi
            //   56                   | push                esi
            //   50                   | push                eax

        $sequence_6 = { ffd6 8b95f0fcffff 8b3d???????? 52 ffd7 68f4010000 }
            // n = 6, score = 800
            //   ffd6                 | call                esi
            //   8b95f0fcffff         | mov                 edx, dword ptr [ebp - 0x310]
            //   8b3d????????         |                     
            //   52                   | push                edx
            //   ffd7                 | call                edi
            //   68f4010000           | push                0x1f4

        $sequence_7 = { 753a 50 50 8d4d8c 51 50 }
            // n = 6, score = 800
            //   753a                 | jne                 0x3c
            //   50                   | push                eax
            //   50                   | push                eax
            //   8d4d8c               | lea                 ecx, [ebp - 0x74]
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_8 = { 488bcf e8???????? b902020000 488d542440 ff15???????? }
            // n = 5, score = 600
            //   488bcf               | mov                 dword ptr [esp + 8], ebx
            //   e8????????           |                     
            //   b902020000           | dec                 eax
            //   488d542440           | mov                 dword ptr [esp + 0x20], esi
            //   ff15????????         |                     

        $sequence_9 = { 32c0 e9???????? 833d????????00 4889bc24e8000000 7412 }
            // n = 5, score = 600
            //   32c0                 | xor                 al, al
            //   e9????????           |                     
            //   833d????????00       |                     
            //   4889bc24e8000000     | dec                 eax
            //   7412                 | mov                 dword ptr [esp + 0xe8], edi

        $sequence_10 = { 48c747300f000000 48897728 488bcf 40887718 }
            // n = 4, score = 600
            //   48c747300f000000     | mov                 ecx, edi
            //   48897728             | mov                 ecx, 0x202
            //   488bcf               | dec                 eax
            //   40887718             | lea                 edx, [esp + 0x40]

        $sequence_11 = { 84c0 7515 488d8c24a0010000 e8???????? }
            // n = 4, score = 600
            //   84c0                 | je                  0x14
            //   7515                 | test                al, al
            //   488d8c24a0010000     | jne                 0x19
            //   e8????????           |                     

        $sequence_12 = { 33d2 4d8b8938010000 4889442428 33c9 }
            // n = 4, score = 600
            //   33d2                 | dec                 ecx
            //   4d8b8938010000       | lea                 edx, [ebp + 0x150]
            //   4889442428           | dec                 ecx
            //   33c9                 | lea                 ecx, [ebp + 0x98]

        $sequence_13 = { 498d9550010000 498d8d98000000 41b804000000 e8???????? 498d8d00010000 }
            // n = 5, score = 600
            //   498d9550010000       | push                edi
            //   498d8d98000000       | dec                 eax
            //   41b804000000         | sub                 esp, 0x4d0
            //   e8????????           |                     
            //   498d8d00010000       | dec                 eax

        $sequence_14 = { 03c2 0fb6c0 2bc2 410fb652fe }
            // n = 4, score = 600
            //   03c2                 | dec                 eax
            //   0fb6c0               | lea                 ecx, [esp + 0x1a0]
            //   2bc2                 | add                 eax, edx
            //   410fb652fe           | movzx               eax, al

        $sequence_15 = { 48895c2408 4889742420 57 4881ecd0040000 }
            // n = 4, score = 600
            //   48895c2408           | sub                 eax, edx
            //   4889742420           | inc                 ecx
            //   57                   | movzx               edx, byte ptr [edx - 2]
            //   4881ecd0040000       | dec                 eax

    condition:
        7 of them and filesize < 548864
}