rule win_ghost_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ghost_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ghost_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bd9 e8???????? 8b4d08 3bc8 }
            // n = 4, score = 500
            //   8bd9                 | mov                 ebx, ecx
            //   e8????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   3bc8                 | cmp                 ecx, eax

        $sequence_1 = { 8b400c 85c0 7505 a1???????? 50 8bce e8???????? }
            // n = 7, score = 500
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   a1????????           |                     
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_2 = { 6a01 56 ff15???????? 5e c20800 }
            // n = 5, score = 500
            //   6a01                 | push                1
            //   56                   | push                esi
            //   ff15????????         |                     
            //   5e                   | pop                 esi
            //   c20800               | ret                 8

        $sequence_3 = { 33c0 5b 8be5 5d c20400 894df4 }
            // n = 6, score = 400
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx

        $sequence_4 = { c745f800000000 df6df4 83ec08 dc0d???????? }
            // n = 4, score = 400
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   df6df4               | fild                qword ptr [ebp - 0xc]
            //   83ec08               | sub                 esp, 8
            //   dc0d????????         |                     

        $sequence_5 = { c20400 894df4 c745f800000000 df6df4 }
            // n = 4, score = 400
            //   c20400               | ret                 4
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   df6df4               | fild                qword ptr [ebp - 0xc]

        $sequence_6 = { 6a6b 8bce e8???????? 5f 5e }
            // n = 5, score = 400
            //   6a6b                 | push                0x6b
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_7 = { 68???????? 50 6802000080 e8???????? 83c41c 5f 5e }
            // n = 7, score = 300
            //   68????????           |                     
            //   50                   | push                eax
            //   6802000080           | push                0x80000002
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_8 = { 68???????? 68???????? 6a00 6a00 c705????????20010000 e8???????? 8b35???????? }
            // n = 7, score = 300
            //   68????????           |                     
            //   68????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   c705????????20010000     |     
            //   e8????????           |                     
            //   8b35????????         |                     

        $sequence_9 = { e8???????? 8b8e549f0000 83c41c 89848e14030000 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   8b8e549f0000         | mov                 ecx, dword ptr [esi + 0x9f54]
            //   83c41c               | add                 esp, 0x1c
            //   89848e14030000       | mov                 dword ptr [esi + ecx*4 + 0x314], eax

        $sequence_10 = { e8???????? 83c40c ff7508 6a40 ff15???????? }
            // n = 5, score = 300
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   ff7508               | push                dword ptr [ebp + 8]
            //   6a40                 | push                0x40
            //   ff15????????         |                     

        $sequence_11 = { ff7510 ff75dc ff15???????? 85c0 7507 }
            // n = 5, score = 300
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9

        $sequence_12 = { e9???????? 8d45dc 50 681f000200 }
            // n = 4, score = 300
            //   e9????????           |                     
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   681f000200           | push                0x2001f

        $sequence_13 = { f7d1 49 7509 5f 5e 5b }
            // n = 6, score = 300
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   7509                 | jne                 0xb
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_14 = { 83c408 e8???????? c1e00a 6a04 }
            // n = 4, score = 300
            //   83c408               | add                 esp, 8
            //   e8????????           |                     
            //   c1e00a               | shl                 eax, 0xa
            //   6a04                 | push                4

        $sequence_15 = { e8???????? 6a6f 8bce e8???????? 5e }
            // n = 5, score = 300
            //   e8????????           |                     
            //   6a6f                 | push                0x6f
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   5e                   | pop                 esi

        $sequence_16 = { 8dbd85feffff f3ab 66ab aa }
            // n = 4, score = 300
            //   8dbd85feffff         | lea                 edi, [ebp - 0x17b]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al

        $sequence_17 = { 83c12c e9???????? 8b4df0 83c154 e9???????? 8b4df0 83c17c }
            // n = 7, score = 300
            //   83c12c               | add                 ecx, 0x2c
            //   e9????????           |                     
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   83c154               | add                 ecx, 0x54
            //   e9????????           |                     
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   83c17c               | add                 ecx, 0x7c

        $sequence_18 = { 8d4e10 e8???????? 6a6b 8bce }
            // n = 4, score = 300
            //   8d4e10               | lea                 ecx, [esi + 0x10]
            //   e8????????           |                     
            //   6a6b                 | push                0x6b
            //   8bce                 | mov                 ecx, esi

        $sequence_19 = { 8365fc00 ff7508 ff15???????? 40 50 ff15???????? 59 }
            // n = 7, score = 300
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   ff15????????         |                     
            //   59                   | pop                 ecx

        $sequence_20 = { e8???????? 84c0 7505 83ceff eb2c }
            // n = 5, score = 300
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7505                 | jne                 7
            //   83ceff               | or                  esi, 0xffffffff
            //   eb2c                 | jmp                 0x2e

        $sequence_21 = { 89849614030000 8b86549f0000 40 8986549f0000 }
            // n = 4, score = 300
            //   89849614030000       | mov                 dword ptr [esi + edx*4 + 0x314], eax
            //   8b86549f0000         | mov                 eax, dword ptr [esi + 0x9f54]
            //   40                   | inc                 eax
            //   8986549f0000         | mov                 dword ptr [esi + 0x9f54], eax

        $sequence_22 = { 6a00 ff7628 ff15???????? 6a01 ff7620 ff15???????? 8b4e04 }
            // n = 7, score = 300
            //   6a00                 | push                0
            //   ff7628               | push                dword ptr [esi + 0x28]
            //   ff15????????         |                     
            //   6a01                 | push                1
            //   ff7620               | push                dword ptr [esi + 0x20]
            //   ff15????????         |                     
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]

        $sequence_23 = { 8bce ff75e8 e8???????? 8bce e8???????? 6a00 }
            // n = 6, score = 300
            //   8bce                 | mov                 ecx, esi
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   6a00                 | push                0

        $sequence_24 = { ff15???????? 6800000002 6a00 6a00 ff15???????? }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   6800000002           | push                0x2000000
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_25 = { 6a00 6a00 6838040000 6a00 6a00 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6838040000           | push                0x438
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_26 = { 83e9fc c7014c696272 83e9fc c70161727941 83e9fc c70100000000 }
            // n = 6, score = 200
            //   83e9fc               | sub                 ecx, -4
            //   c7014c696272         | mov                 dword ptr [ecx], 0x7262694c
            //   83e9fc               | sub                 ecx, -4
            //   c70161727941         | mov                 dword ptr [ecx], 0x41797261
            //   83e9fc               | sub                 ecx, -4
            //   c70100000000         | mov                 dword ptr [ecx], 0

        $sequence_27 = { 8b4608 8b7e20 8b36 813f6b006500 7406 813f4b004500 75e8 }
            // n = 7, score = 200
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   8b7e20               | mov                 edi, dword ptr [esi + 0x20]
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   813f6b006500         | cmp                 dword ptr [edi], 0x65006b
            //   7406                 | je                  8
            //   813f4b004500         | cmp                 dword ptr [edi], 0x45004b
            //   75e8                 | jne                 0xffffffea

        $sequence_28 = { ff8b8d60ffff ff03 0c90 898df4feffff }
            // n = 4, score = 100
            //   ff8b8d60ffff         | dec                 dword ptr [ebx - 0x9f73]
            //   ff03                 | inc                 dword ptr [ebx]
            //   0c90                 | or                  al, 0x90
            //   898df4feffff         | mov                 dword ptr [ebp - 0x10c], ecx

        $sequence_29 = { 8b4df0 51 8b9558ffffff 52 8b8560ffffff 50 }
            // n = 6, score = 100
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   51                   | push                ecx
            //   8b9558ffffff         | mov                 edx, dword ptr [ebp - 0xa8]
            //   52                   | push                edx
            //   8b8560ffffff         | mov                 eax, dword ptr [ebp - 0xa0]
            //   50                   | push                eax

        $sequence_30 = { 83c40c c7856cffffff00000000 eb0f 8b8d6cffffff 83c101 }
            // n = 5, score = 100
            //   83c40c               | add                 esp, 0xc
            //   c7856cffffff00000000     | mov    dword ptr [ebp - 0x94], 0
            //   eb0f                 | jmp                 0x11
            //   8b8d6cffffff         | mov                 ecx, dword ptr [ebp - 0x94]
            //   83c101               | add                 ecx, 1

        $sequence_31 = { 03480c 894dc0 8b55c0 52 8b450c }
            // n = 5, score = 100
            //   03480c               | add                 ecx, dword ptr [eax + 0xc]
            //   894dc0               | mov                 dword ptr [ebp - 0x40], ecx
            //   8b55c0               | mov                 edx, dword ptr [ebp - 0x40]
            //   52                   | push                edx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_32 = { 8d9530ffffff 52 6a40 8b4580 }
            // n = 4, score = 100
            //   8d9530ffffff         | lea                 edx, [ebp - 0xd0]
            //   52                   | push                edx
            //   6a40                 | push                0x40
            //   8b4580               | mov                 eax, dword ptr [ebp - 0x80]

        $sequence_33 = { 8b423c 8945ec 8b8d58ffffff 034dec }
            // n = 4, score = 100
            //   8b423c               | mov                 eax, dword ptr [edx + 0x3c]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8b8d58ffffff         | mov                 ecx, dword ptr [ebp - 0xa8]
            //   034dec               | add                 ecx, dword ptr [ebp - 0x14]

    condition:
        7 of them and filesize < 357376
}