rule win_ghost_secret_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ghost_secret."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ghost_secret"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c408 50 56 ff15???????? 8d8c24a4050000 6a13 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8d8c24a4050000       | lea                 ecx, [esp + 0x5a4]
            //   6a13                 | push                0x13

        $sequence_1 = { c68424eb02000040 c68424ec02000017 c68424ed02000034 c68424ee020000da c68424ef020000f8 c68424f002000003 c68424f1020000c7 }
            // n = 7, score = 200
            //   c68424eb02000040     | mov                 byte ptr [esp + 0x2eb], 0x40
            //   c68424ec02000017     | mov                 byte ptr [esp + 0x2ec], 0x17
            //   c68424ed02000034     | mov                 byte ptr [esp + 0x2ed], 0x34
            //   c68424ee020000da     | mov                 byte ptr [esp + 0x2ee], 0xda
            //   c68424ef020000f8     | mov                 byte ptr [esp + 0x2ef], 0xf8
            //   c68424f002000003     | mov                 byte ptr [esp + 0x2f0], 3
            //   c68424f1020000c7     | mov                 byte ptr [esp + 0x2f1], 0xc7

        $sequence_2 = { 85c0 55 7518 68beb60000 e8???????? 83c408 5f }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   55                   | push                ebp
            //   7518                 | jne                 0x1a
            //   68beb60000           | push                0xb6be
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   5f                   | pop                 edi

        $sequence_3 = { c68424c8070000a6 c68424c9070000c9 c68424ca0700004e c68424cb07000072 c68424cc07000008 c68424cd070000dc c68424ce0700007b }
            // n = 7, score = 200
            //   c68424c8070000a6     | mov                 byte ptr [esp + 0x7c8], 0xa6
            //   c68424c9070000c9     | mov                 byte ptr [esp + 0x7c9], 0xc9
            //   c68424ca0700004e     | mov                 byte ptr [esp + 0x7ca], 0x4e
            //   c68424cb07000072     | mov                 byte ptr [esp + 0x7cb], 0x72
            //   c68424cc07000008     | mov                 byte ptr [esp + 0x7cc], 8
            //   c68424cd070000dc     | mov                 byte ptr [esp + 0x7cd], 0xdc
            //   c68424ce0700007b     | mov                 byte ptr [esp + 0x7ce], 0x7b

        $sequence_4 = { 6689442460 50 8b44247c c744242400000000 50 6a00 }
            // n = 6, score = 200
            //   6689442460           | mov                 word ptr [esp + 0x60], ax
            //   50                   | push                eax
            //   8b44247c             | mov                 eax, dword ptr [esp + 0x7c]
            //   c744242400000000     | mov                 dword ptr [esp + 0x24], 0
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_5 = { c684243e04000031 c684243f040000cb c68424400400006c c68424410400006c c684244204000075 }
            // n = 5, score = 200
            //   c684243e04000031     | mov                 byte ptr [esp + 0x43e], 0x31
            //   c684243f040000cb     | mov                 byte ptr [esp + 0x43f], 0xcb
            //   c68424400400006c     | mov                 byte ptr [esp + 0x440], 0x6c
            //   c68424410400006c     | mov                 byte ptr [esp + 0x441], 0x6c
            //   c684244204000075     | mov                 byte ptr [esp + 0x442], 0x75

        $sequence_6 = { 8d54244c 57 52 50 ff15???????? 85c0 }
            // n = 6, score = 200
            //   8d54244c             | lea                 edx, [esp + 0x4c]
            //   57                   | push                edi
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_7 = { 75dc 5f 5e 5d b890f0ffff 5b c3 }
            // n = 7, score = 200
            //   75dc                 | jne                 0xffffffde
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   b890f0ffff           | mov                 eax, 0xfffff090
            //   5b                   | pop                 ebx
            //   c3                   | ret                 

        $sequence_8 = { c68424b7070000d1 c68424b40400004b 888c24b5040000 c68424b60400007e c68424b704000049 c68424b80400006e c68424b904000070 }
            // n = 7, score = 200
            //   c68424b7070000d1     | mov                 byte ptr [esp + 0x7b7], 0xd1
            //   c68424b40400004b     | mov                 byte ptr [esp + 0x4b4], 0x4b
            //   888c24b5040000       | mov                 byte ptr [esp + 0x4b5], cl
            //   c68424b60400007e     | mov                 byte ptr [esp + 0x4b6], 0x7e
            //   c68424b704000049     | mov                 byte ptr [esp + 0x4b7], 0x49
            //   c68424b80400006e     | mov                 byte ptr [esp + 0x4b8], 0x6e
            //   c68424b904000070     | mov                 byte ptr [esp + 0x4b9], 0x70

        $sequence_9 = { 8b440e08 83f809 0f87cf000000 ff248520ae4000 6a07 8d542444 e9???????? }
            // n = 7, score = 200
            //   8b440e08             | mov                 eax, dword ptr [esi + ecx + 8]
            //   83f809               | cmp                 eax, 9
            //   0f87cf000000         | ja                  0xd5
            //   ff248520ae4000       | jmp                 dword ptr [eax*4 + 0x40ae20]
            //   6a07                 | push                7
            //   8d542444             | lea                 edx, [esp + 0x44]
            //   e9????????           |                     

    condition:
        7 of them and filesize < 278528
}