rule win_ghostemperor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ghostemperor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ghostemperor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c7464800000000 488d4e18 ff15???????? 488b4e40 }
            // n = 4, score = 200
            //   c7464800000000       | mov                 eax, dword ptr [ebp + 0x10]
            //   488d4e18             | mov                 eax, dword ptr [eax + 0x4c]
            //   ff15????????         |                     
            //   488b4e40             | rol                 eax, 5

        $sequence_1 = { 89d5 4889ce b920000000 e8???????? 4889c7 0f57c0 0f2900 }
            // n = 7, score = 200
            //   89d5                 | sub                 ebx, edx
            //   4889ce               | add                 ecx, edx
            //   b920000000           | mov                 edx, ecx
            //   e8????????           |                     
            //   4889c7               | shl                 edx, 5
            //   0f57c0               | mov                 ebx, ecx
            //   0f2900               | sub                 ebx, edx

        $sequence_2 = { 4885c9 7443 4889ce ff15???????? }
            // n = 4, score = 200
            //   4885c9               | add                 ebx, ecx
            //   7443                 | add                 ebx, eax
            //   4889ce               | add                 eax, 0x4fa9727
            //   ff15????????         |                     

        $sequence_3 = { 4883c601 4883c2f8 39f1 75ec 4929d1 }
            // n = 5, score = 200
            //   4883c601             | xor                 eax, 0x65a63713
            //   4883c2f8             | mov                 dword ptr [ebp - 0xc], eax
            //   39f1                 | dec                 eax
            //   75ec                 | mov                 eax, dword ptr [ebp + 0x10]
            //   4929d1               | add                 eax, 0x4fa9727

        $sequence_4 = { 4883ec28 ff15???????? 488d542424 89c1 ff15???????? 85c0 7406 }
            // n = 7, score = 200
            //   4883ec28             | mov                 eax, dword ptr [eax + 0x4c]
            //   ff15????????         |                     
            //   488d542424           | add                 eax, 0x4fa9727
            //   89c1                 | xor                 eax, 0x65a63713
            //   ff15????????         |                     
            //   85c0                 | mov                 dword ptr [ebp - 0xc], eax
            //   7406                 | dec                 eax

        $sequence_5 = { 418d42ff 4c8d5801 4983fb04 7222 488d3cc2 4883c708 }
            // n = 6, score = 200
            //   418d42ff             | add                 ebx, ecx
            //   4c8d5801             | add                 ecx, edx
            //   4983fb04             | mov                 edx, ecx
            //   7222                 | shl                 edx, 5
            //   488d3cc2             | mov                 ebx, ecx
            //   4883c708             | sub                 ebx, edx

        $sequence_6 = { 4839cf 0f86fb000000 488d04c1 4883c008 }
            // n = 4, score = 200
            //   4839cf               | xor                 eax, 0x65a63713
            //   0f86fb000000         | mov                 dword ptr [ebp - 0xc], eax
            //   488d04c1             | dec                 eax
            //   4883c008             | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_7 = { 488d5108 e8???????? 8b4648 85c0 746e }
            // n = 5, score = 200
            //   488d5108             | add                 eax, 0x4fa9727
            //   e8????????           |                     
            //   8b4648               | xor                 eax, 0x65a63713
            //   85c0                 | mov                 dword ptr [ebp - 0xc], eax
            //   746e                 | dec                 eax

        $sequence_8 = { 49895d38 41897530 eb18 418b07 85c0 7411 4c03f8 }
            // n = 7, score = 100
            //   49895d38             | xor                 ecx, ecx
            //   41897530             | dec                 eax
            //   eb18                 | mov                 edi, eax
            //   418b07               | dec                 eax
            //   85c0                 | and                 dword ptr [esi + eax*8 + 8], 0
            //   7411                 | mov                 dl, byte ptr [eax + 8]
            //   4c03f8               | dec                 eax

        $sequence_9 = { 01c3 69cbe8030000 81c130750000 4883ec20 }
            // n = 4, score = 100
            //   01c3                 | dec                 eax
            //   69cbe8030000         | mov                 eax, dword ptr [ebp + 0x268]
            //   81c130750000         | mov                 byte ptr [eax + ecx + 0xc], dl
            //   4883ec20             | dec                 eax

        $sequence_10 = { 01c1 89ca c1ea1f c1f904 }
            // n = 4, score = 100
            //   01c1                 | mov                 edx, dword ptr [ebp + 0x2b0]
            //   89ca                 | mov                 byte ptr [eax + edx + 0xc], cl
            //   c1ea1f               | dec                 eax
            //   c1f904               | mov                 ecx, dword ptr [ebp + 0x2b0]

        $sequence_11 = { 488364c60800 488b05???????? 8a5008 488d4810 ff15???????? }
            // n = 5, score = 100
            //   488364c60800         | dec                 eax
            //   488b05????????       |                     
            //   8a5008               | mov                 ebp, dword ptr [esp + 0x38]
            //   488d4810             | dec                 eax
            //   ff15????????         |                     

        $sequence_12 = { 41391e 0f84fc010000 418b06 85c0 745d 448b4540 }
            // n = 6, score = 100
            //   41391e               | lea                 ecx, [eax + 0x10]
            //   0f84fc010000         | mov                 dword ptr [ebp + 0x50], 0x73005f
            //   418b06               | mov                 dword ptr [ebp + 0x54], 0x5200ee
            //   85c0                 | movups              xmmword ptr [ebp + 0x3c8], xmm0
            //   745d                 | mov                 dword ptr [ebp + 0x58], 0x5600ec
            //   448b4540             | mov                 dword ptr [ebp + 0x5c], 0x850005

        $sequence_13 = { 052797fa04 351337a665 8945f4 488b4510 }
            // n = 4, score = 100
            //   052797fa04           | add                 ecx, edx
            //   351337a665           | mov                 edx, ecx
            //   8945f4               | shl                 edx, 5
            //   488b4510             | add                 ebx, eax

        $sequence_14 = { 4154 4156 488d6898 4881ec50010000 4533f6 4c8d257b390000 488bd9 }
            // n = 7, score = 100
            //   4154                 | inc                 ecx
            //   4156                 | push                esp
            //   488d6898             | inc                 ecx
            //   4881ec50010000       | push                esi
            //   4533f6               | dec                 eax
            //   4c8d257b390000       | lea                 ebp, [eax - 0x68]
            //   488bd9               | dec                 eax

        $sequence_15 = { 05f226dac9 35bcfe1eea 894534 488b4550 }
            // n = 4, score = 100
            //   05f226dac9           | add                 ebx, ecx
            //   35bcfe1eea           | add                 ebx, eax
            //   894534               | imul                ecx, ebx, 0x3e8
            //   488b4550             | add                 ecx, 0x7530

        $sequence_16 = { c745505f007300 c74554ee005200 0f1185c8030000 c74558ec005600 c7455c05008500 0f104d50 }
            // n = 6, score = 100
            //   c745505f007300       | mov                 esi, dword ptr [esp + 0x40]
            //   c74554ee005200       | dec                 eax
            //   0f1185c8030000       | mov                 dword ptr [edi + 0x38], ecx
            //   c74558ec005600       | cmp                 eax, 0xc0000004
            //   c7455c05008500       | jne                 0x6e
            //   0f104d50             | mov                 edx, dword ptr [esp + 0x50]

        $sequence_17 = { 00c2 488b8568020000 8854080c 488b85b0020000 }
            // n = 4, score = 100
            //   00c2                 | mov                 edx, dword ptr [ebp + 0x2b0]
            //   488b8568020000       | mov                 byte ptr [eax + edx + 0xc], cl
            //   8854080c             | dec                 eax
            //   488b85b0020000       | mov                 eax, dword ptr [ebp + 0x2b0]

        $sequence_18 = { 488bcf 2b542428 83c207 e8???????? 85c0 }
            // n = 5, score = 100
            //   488bcf               | sub                 esp, 0x150
            //   2b542428             | inc                 ebp
            //   83c207               | xor                 esi, esi
            //   e8????????           |                     
            //   85c0                 | dec                 esp

        $sequence_19 = { 0552f0384d 358e257f87 894530 488b4570 }
            // n = 4, score = 100
            //   0552f0384d           | dec                 eax
            //   358e257f87           | add                 esp, 0x20
            //   894530               | add                 ebx, eax
            //   488b4570             | imul                ecx, ebx, 0x3e8

        $sequence_20 = { 01d1 89ca c1e205 89cb }
            // n = 4, score = 100
            //   01d1                 | mov                 eax, dword ptr [ebp + 0x2b0]
            //   89ca                 | mov                 eax, dword ptr [ebp + 0x2c8]
            //   c1e205               | mov                 eax, dword ptr [ebp + 0x2c8]
            //   89cb                 | add                 ecx, eax

        $sequence_21 = { 3d040000c0 7567 8b542450 33c9 ff15???????? 488bf8 }
            // n = 6, score = 100
            //   3d040000c0           | mov                 ecx, edi
            //   7567                 | sub                 edx, dword ptr [esp + 0x28]
            //   8b542450             | add                 edx, 7
            //   33c9                 | test                eax, eax
            //   ff15????????         |                     
            //   488bf8               | xor                 eax, eax

        $sequence_22 = { 00c1 488b8568020000 488b95b0020000 884c100c }
            // n = 4, score = 100
            //   00c1                 | jmp                 0x1a
            //   488b8568020000       | inc                 ecx
            //   488b95b0020000       | mov                 eax, dword ptr [edi]
            //   884c100c             | test                eax, eax

        $sequence_23 = { 33c0 488b6c2438 488b742440 48894f38 }
            // n = 4, score = 100
            //   33c0                 | lea                 esp, [0x397b]
            //   488b6c2438           | dec                 eax
            //   488b742440           | mov                 ebx, ecx
            //   48894f38             | dec                 eax

    condition:
        7 of them and filesize < 1115136
}