rule win_ghostsocks_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ghostsocks."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ghostsocks"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f7e2 69df90010000 01da 89c3 }
            // n = 4, score = 300
            //   f7e2                 | mul                 edx
            //   69df90010000         | imul                ebx, edi, 0x190
            //   01da                 | add                 edx, ebx
            //   89c3                 | mov                 ebx, eax

        $sequence_1 = { f7e2 7079 8d5504 89d5 }
            // n = 4, score = 300
            //   f7e2                 | mul                 edx
            //   7079                 | jo                  0x7b
            //   8d5504               | lea                 edx, [ebp + 4]
            //   89d5                 | mov                 ebp, edx

        $sequence_2 = { f7e2 0fafe9 8b4c2418 0fafcb }
            // n = 4, score = 300
            //   f7e2                 | mul                 edx
            //   0fafe9               | imul                ebp, ecx
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   0fafcb               | imul                ecx, ebx

        $sequence_3 = { f7e2 707d 83f8ff 7772 8b542418 85d2 }
            // n = 6, score = 300
            //   f7e2                 | mul                 edx
            //   707d                 | jo                  0x7f
            //   83f8ff               | cmp                 eax, -1
            //   7772                 | ja                  0x74
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   85d2                 | test                edx, edx

        $sequence_4 = { f7e2 01d1 81e5ffffff3f 89ea c1fd1f 90 }
            // n = 6, score = 300
            //   f7e2                 | mul                 edx
            //   01d1                 | add                 ecx, edx
            //   81e5ffffff3f         | and                 ebp, 0x3fffffff
            //   89ea                 | mov                 edx, ebp
            //   c1fd1f               | sar                 ebp, 0x1f
            //   90                   | nop                 

        $sequence_5 = { f7e2 89442468 0fafde 01da }
            // n = 4, score = 300
            //   f7e2                 | mul                 edx
            //   89442468             | mov                 dword ptr [esp + 0x68], eax
            //   0fafde               | imul                ebx, esi
            //   01da                 | add                 edx, ebx

        $sequence_6 = { f7e2 83c6f8 90 90 83c308 }
            // n = 5, score = 300
            //   f7e2                 | mul                 edx
            //   83c6f8               | add                 esi, -8
            //   90                   | nop                 
            //   90                   | nop                 
            //   83c308               | add                 ebx, 8

        $sequence_7 = { f7e2 89442428 01d1 05000096b3 }
            // n = 4, score = 300
            //   f7e2                 | mul                 edx
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   01d1                 | add                 ecx, edx
            //   05000096b3           | add                 eax, 0xb3960000

        $sequence_8 = { e8???????? 89856068fcff 89956468fcff 8d8d1bc3faff }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89856068fcff         | mov                 dword ptr [ebp - 0x397a0], eax
            //   89956468fcff         | mov                 dword ptr [ebp - 0x3979c], edx
            //   8d8d1bc3faff         | lea                 ecx, [ebp - 0x53ce5]

        $sequence_9 = { e8???????? 89856071fcff 89956471fcff a1???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89856071fcff         | mov                 dword ptr [ebp - 0x38ea0], eax
            //   89956471fcff         | mov                 dword ptr [ebp - 0x38e9c], edx
            //   a1????????           |                     

        $sequence_10 = { e8???????? 89856077feff 89956477feff 8b8d647ffeff }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89856077feff         | mov                 dword ptr [ebp - 0x188a0], eax
            //   89956477feff         | mov                 dword ptr [ebp - 0x1889c], edx
            //   8b8d647ffeff         | mov                 ecx, dword ptr [ebp - 0x1809c]

        $sequence_11 = { e8???????? 89856082fcff 89956482fcff 0fb685a77cffff }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89856082fcff         | mov                 dword ptr [ebp - 0x37da0], eax
            //   89956482fcff         | mov                 dword ptr [ebp - 0x37d9c], edx
            //   0fb685a77cffff       | movzx               eax, byte ptr [ebp - 0x8359]

        $sequence_12 = { e8???????? 89856078fbff 89956478fbff 8b0d???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89856078fbff         | mov                 dword ptr [ebp - 0x487a0], eax
            //   89956478fbff         | mov                 dword ptr [ebp - 0x4879c], edx
            //   8b0d????????         |                     

        $sequence_13 = { e8???????? 8985605ffdff 8995645ffdff 0fb6856fd5faff }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8985605ffdff         | mov                 dword ptr [ebp - 0x2a0a0], eax
            //   8995645ffdff         | mov                 dword ptr [ebp - 0x2a09c], edx
            //   0fb6856fd5faff       | movzx               eax, byte ptr [ebp - 0x52a91]

        $sequence_14 = { e8???????? 89856076fcff 89956476fcff 8b85d0adfdff }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89856076fcff         | mov                 dword ptr [ebp - 0x389a0], eax
            //   89956476fcff         | mov                 dword ptr [ebp - 0x3899c], edx
            //   8b85d0adfdff         | mov                 eax, dword ptr [ebp - 0x25230]

        $sequence_15 = { e8???????? 89856074fbff 89956474fbff a1???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89856074fbff         | mov                 dword ptr [ebp - 0x48ba0], eax
            //   89956474fbff         | mov                 dword ptr [ebp - 0x48b9c], edx
            //   a1????????           |                     

    condition:
        7 of them and filesize < 25016320
}