rule win_giftedcrook_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.giftedcrook."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.giftedcrook"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 744f 4c8bca 4c8d05da9d0400 ba80000000 488d4c2430 e8???????? 0fb69f550a0000 }
            // n = 7, score = 100
            //   744f                 | mov                 eax, 0x15
            //   4c8bca               | dec                 eax
            //   4c8d05da9d0400       | lea                 edx, [0x5c522]
            //   ba80000000           | dec                 eax
            //   488d4c2430           | mov                 ecx, edi
            //   e8????????           |                     
            //   0fb69f550a0000       | test                eax, eax

        $sequence_1 = { 488983300d0000 488d15b0720800 c683500d000001 488bcb e8???????? 488b457f 33ff }
            // n = 7, score = 100
            //   488983300d0000       | test                eax, eax
            //   488d15b0720800       | jne                 0x1511
            //   c683500d000001       | dec                 eax
            //   488bcb               | lea                 edx, [0x76680]
            //   e8????????           |                     
            //   488b457f             | dec                 eax
            //   33ff                 | lea                 ecx, [0x74f17]

        $sequence_2 = { 4c8bc6 488d154a270500 488bcf e8???????? ba01000000 488bcf e8???????? }
            // n = 7, score = 100
            //   4c8bc6               | dec                 eax
            //   488d154a270500       | lea                 ecx, [0x76a23]
            //   488bcf               | test                eax, eax
            //   e8????????           |                     
            //   ba01000000           | jne                 0x1c27
            //   488bcf               | je                  0x1c3f
            //   e8????????           |                     

        $sequence_3 = { 0fbe4550 83c0d3 83f846 0f8794feffff 4898 0fb68402e00e0300 8b8c82bc0e0300 }
            // n = 7, score = 100
            //   0fbe4550             | lea                 edx, [0x38665]
            //   83c0d3               | inc                 ebp
            //   83f846               | xor                 esi, esi
            //   0f8794feffff         | dec                 eax
            //   4898                 | mov                 dword ptr [ebp - 0x48], ecx
            //   0fb68402e00e0300     | xorps               xmm0, xmm0
            //   8b8c82bc0e0300       | dec                 eax

        $sequence_4 = { e8???????? 4c8bf0 4885c0 7512 48396f60 740c 4c8d35bbff0700 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8bf0               | inc                 esp
            //   4885c0               | movzx               eax, byte ptr [edi]
            //   7512                 | dec                 eax
            //   48396f60             | lea                 edx, [0x40b90]
            //   740c                 | dec                 eax
            //   4c8d35bbff0700       | lea                 ecx, [esp + 0x60]

        $sequence_5 = { 4c8b8d50070000 4c8d05aa0f0500 488d9598060000 e8???????? 8bf8 85c0 750a }
            // n = 7, score = 100
            //   4c8b8d50070000       | je                  0x11e1
            //   4c8d05aa0f0500       | cmp                 byte ptr [eax], 0
            //   488d9598060000       | je                  0x11e1
            //   e8????????           |                     
            //   8bf8                 | dec                 eax
            //   85c0                 | lea                 edx, [0x62cdb]
            //   750a                 | dec                 eax

        $sequence_6 = { 4489442440 488d4c2450 89542438 4c8d05d2240500 44895c2430 ba18000000 4489542428 }
            // n = 7, score = 100
            //   4489442440           | dec                 esp
            //   488d4c2450           | lea                 eax, [0x61f57]
            //   89542438             | sete                al
            //   4c8d05d2240500       | mov                 edi, eax
            //   44895c2430           | dec                 eax
            //   ba18000000           | lea                 eax, [0x5073f]
            //   4489542428           | dec                 eax

        $sequence_7 = { 4c8d05d21a0500 e8???????? 8bf8 85c0 }
            // n = 4, score = 100
            //   4c8d05d21a0500       | lea                 edx, [0x5e744]
            //   e8????????           |                     
            //   8bf8                 | dec                 ecx
            //   85c0                 | mov                 ecx, edi

        $sequence_8 = { 8bf2 4c8d0d3d500200 488be9 4c8d052b500200 488d152c500200 b901000000 e8???????? }
            // n = 7, score = 100
            //   8bf2                 | dec                 eax
            //   4c8d0d3d500200       | lea                 ecx, [0x83bcb]
            //   488be9               | dec                 eax
            //   4c8d052b500200       | mov                 edx, ebx
            //   488d152c500200       | test                eax, eax
            //   b901000000           | je                  0x9fe
            //   e8????????           |                     

        $sequence_9 = { 48896c2420 4c8d2d28dc0600 448bcf 4d0f45e8 488d1522dc0600 4d8bc5 498bcc }
            // n = 7, score = 100
            //   48896c2420           | cmp                 byte ptr [esi + 0x1342], 2
            //   4c8d2d28dc0600       | dec                 eax
            //   448bcf               | lea                 edx, [0x69272]
            //   4d0f45e8             | dec                 esp
            //   488d1522dc0600       | mov                 eax, dword ptr [ebx + 0x1428]
            //   4d8bc5               | dec                 eax
            //   498bcc               | mov                 ecx, ebx

    condition:
        7 of them and filesize < 1605632
}