rule win_glitch_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.glitch_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.glitch_pos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b00 ff7508 ff9010030000 50 8d45c4 50 e8???????? }
            // n = 7, score = 100
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff9010030000         | call                dword ptr [eax + 0x310]
            //   50                   | push                eax
            //   8d45c4               | lea                 eax, [ebp - 0x3c]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_1 = { 8b4508 8b4034 83c001 0f80b9060000 8b4d08 894134 8b4508 }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4034               | mov                 eax, dword ptr [eax + 0x34]
            //   83c001               | add                 eax, 1
            //   0f80b9060000         | jo                  0x6bf
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   894134               | mov                 dword ptr [ecx + 0x34], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_2 = { 8b00 ff7508 ff902c070000 6683bd2cffffffff 0f85f7030000 8b4508 8b00 }
            // n = 7, score = 100
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff902c070000         | call                dword ptr [eax + 0x72c]
            //   6683bd2cffffffff     | cmp                 word ptr [ebp - 0xd4], -1
            //   0f85f7030000         | jne                 0x3fd
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_3 = { e8???????? 8945dc 8d45e0 50 8b450c 668b00 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   668b00               | mov                 ax, word ptr [eax]

        $sequence_4 = { 50 8b8554ffffff 8b00 ffb554ffffff ff5054 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   8b8554ffffff         | mov                 eax, dword ptr [ebp - 0xac]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ffb554ffffff         | push                dword ptr [ebp - 0xac]
            //   ff5054               | call                dword ptr [eax + 0x54]

        $sequence_5 = { 668985f0feffff 8d8568ffffff 50 8d8578ffffff 50 8d4598 50 }
            // n = 7, score = 100
            //   668985f0feffff       | mov                 word ptr [ebp - 0x110], ax
            //   8d8568ffffff         | lea                 eax, [ebp - 0x98]
            //   50                   | push                eax
            //   8d8578ffffff         | lea                 eax, [ebp - 0x88]
            //   50                   | push                eax
            //   8d4598               | lea                 eax, [ebp - 0x68]
            //   50                   | push                eax

        $sequence_6 = { 8d4588 50 8b856cffffff 8b00 ffb56cffffff ff90d8000000 }
            // n = 6, score = 100
            //   8d4588               | lea                 eax, [ebp - 0x78]
            //   50                   | push                eax
            //   8b856cffffff         | mov                 eax, dword ptr [ebp - 0x94]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ffb56cffffff         | push                dword ptr [ebp - 0x94]
            //   ff90d8000000         | call                dword ptr [eax + 0xd8]

        $sequence_7 = { ffb5dcfeffff e8???????? 89852cfeffff eb07 83a52cfeffff00 8b45c0 }
            // n = 6, score = 100
            //   ffb5dcfeffff         | push                dword ptr [ebp - 0x124]
            //   e8????????           |                     
            //   89852cfeffff         | mov                 dword ptr [ebp - 0x1d4], eax
            //   eb07                 | jmp                 9
            //   83a52cfeffff00       | and                 dword ptr [ebp - 0x1d4], 0
            //   8b45c0               | mov                 eax, dword ptr [ebp - 0x40]

        $sequence_8 = { 83658000 8d45dc 50 8d45d8 50 8d45e0 }
            // n = 6, score = 100
            //   83658000             | and                 dword ptr [ebp - 0x80], 0
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]

        $sequence_9 = { ff75d8 e8???????? dc9d68ffffff dfe0 }
            // n = 4, score = 100
            //   ff75d8               | push                dword ptr [ebp - 0x28]
            //   e8????????           |                     
            //   dc9d68ffffff         | fcomp               qword ptr [ebp - 0x98]
            //   dfe0                 | fnstsw              ax

    condition:
        7 of them and filesize < 1024000
}