rule win_global_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.global."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.global"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b44243c 8d1c2a 8d341f 03c6 89442468 }
            // n = 5, score = 100
            //   8b44243c             | mov                 eax, dword ptr [esp + 0x3c]
            //   8d1c2a               | lea                 ebx, [edx + ebp]
            //   8d341f               | lea                 esi, [edi + ebx]
            //   03c6                 | add                 eax, esi
            //   89442468             | mov                 dword ptr [esp + 0x68], eax

        $sequence_1 = { 899634100000 8b54be3c c1c80a c1ca17 33d0 8b8610100000 c1c808 }
            // n = 7, score = 100
            //   899634100000         | mov                 dword ptr [esi + 0x1034], edx
            //   8b54be3c             | mov                 edx, dword ptr [esi + edi*4 + 0x3c]
            //   c1c80a               | ror                 eax, 0xa
            //   c1ca17               | ror                 edx, 0x17
            //   33d0                 | xor                 edx, eax
            //   8b8610100000         | mov                 eax, dword ptr [esi + 0x1010]
            //   c1c808               | ror                 eax, 8

        $sequence_2 = { 807e1400 7507 8bce e8???????? 8b5e0c 8b7730 }
            // n = 6, score = 100
            //   807e1400             | cmp                 byte ptr [esi + 0x14], 0
            //   7507                 | jne                 9
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8b5e0c               | mov                 ebx, dword ptr [esi + 0xc]
            //   8b7730               | mov                 esi, dword ptr [edi + 0x30]

        $sequence_3 = { 8bc2 c1e808 884306 884b03 885307 8b4d08 8bc1 }
            // n = 7, score = 100
            //   8bc2                 | mov                 eax, edx
            //   c1e808               | shr                 eax, 8
            //   884306               | mov                 byte ptr [ebx + 6], al
            //   884b03               | mov                 byte ptr [ebx + 3], cl
            //   885307               | mov                 byte ptr [ebx + 7], dl
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8bc1                 | mov                 eax, ecx

        $sequence_4 = { 23cb 23ce 03c9 c1f91f 23ca 8b54242c c1fa1f }
            // n = 7, score = 100
            //   23cb                 | and                 ecx, ebx
            //   23ce                 | and                 ecx, esi
            //   03c9                 | add                 ecx, ecx
            //   c1f91f               | sar                 ecx, 0x1f
            //   23ca                 | and                 ecx, edx
            //   8b54242c             | mov                 edx, dword ptr [esp + 0x2c]
            //   c1fa1f               | sar                 edx, 0x1f

        $sequence_5 = { 6a01 51 e8???????? 8b8c2430020000 8bc6 5f 5e }
            // n = 7, score = 100
            //   6a01                 | push                1
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b8c2430020000       | mov                 ecx, dword ptr [esp + 0x230]
            //   8bc6                 | mov                 eax, esi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_6 = { 7412 8b4c2434 ff7108 57 50 e8???????? 83c40c }
            // n = 7, score = 100
            //   7412                 | je                  0x14
            //   8b4c2434             | mov                 ecx, dword ptr [esp + 0x34]
            //   ff7108               | push                dword ptr [ecx + 8]
            //   57                   | push                edi
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_7 = { 8b8e4c100000 899678100000 8b949e00080000 c1c816 c1ca09 33d0 }
            // n = 6, score = 100
            //   8b8e4c100000         | mov                 ecx, dword ptr [esi + 0x104c]
            //   899678100000         | mov                 dword ptr [esi + 0x1078], edx
            //   8b949e00080000       | mov                 edx, dword ptr [esi + ebx*4 + 0x800]
            //   c1c816               | ror                 eax, 0x16
            //   c1ca09               | ror                 edx, 9
            //   33d0                 | xor                 edx, eax

        $sequence_8 = { 8db8bc4d4300 57 ff15???????? ff0d???????? 83ef18 83ee01 75eb }
            // n = 7, score = 100
            //   8db8bc4d4300         | lea                 edi, [eax + 0x434dbc]
            //   57                   | push                edi
            //   ff15????????         |                     
            //   ff0d????????         |                     
            //   83ef18               | sub                 edi, 0x18
            //   83ee01               | sub                 esi, 1
            //   75eb                 | jne                 0xffffffed

        $sequence_9 = { e8???????? 8d85b80c0000 50 ff75ac ff75a8 e8???????? 83c418 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d85b80c0000         | lea                 eax, [ebp + 0xcb8]
            //   50                   | push                eax
            //   ff75ac               | push                dword ptr [ebp - 0x54]
            //   ff75a8               | push                dword ptr [ebp - 0x58]
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18

    condition:
        7 of them and filesize < 475136
}