rule win_globeimposter_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.globeimposter."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.globeimposter"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 837c243020 57 8bfd 7608 6ac4 58 }
            // n = 6, score = 700
            //   837c243020           | cmp                 dword ptr [esp + 0x30], 0x20
            //   57                   | push                edi
            //   8bfd                 | mov                 edi, ebp
            //   7608                 | jbe                 0xa
            //   6ac4                 | push                -0x3c
            //   58                   | pop                 eax

        $sequence_1 = { 57 83fd08 0f8205010000 8bc5 }
            // n = 4, score = 700
            //   57                   | push                edi
            //   83fd08               | cmp                 ebp, 8
            //   0f8205010000         | jb                  0x10b
            //   8bc5                 | mov                 eax, ebp

        $sequence_2 = { 85ff 7452 8bef 8bf0 8b06 8d7604 }
            // n = 6, score = 700
            //   85ff                 | test                edi, edi
            //   7452                 | je                  0x54
            //   8bef                 | mov                 ebp, edi
            //   8bf0                 | mov                 esi, eax
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8d7604               | lea                 esi, [esi + 4]

        $sequence_3 = { 8b4508 8b4e08 89442418 85ff 7452 }
            // n = 5, score = 700
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   85ff                 | test                edi, edi
            //   7452                 | je                  0x54

        $sequence_4 = { e8???????? 85f6 7408 8d8600bdffff }
            // n = 4, score = 700
            //   e8????????           |                     
            //   85f6                 | test                esi, esi
            //   7408                 | je                  0xa
            //   8d8600bdffff         | lea                 eax, [esi - 0x4300]

        $sequence_5 = { 3dfa000000 7205 6a0c 5f eb0d }
            // n = 5, score = 700
            //   3dfa000000           | cmp                 eax, 0xfa
            //   7205                 | jb                  7
            //   6a0c                 | push                0xc
            //   5f                   | pop                 edi
            //   eb0d                 | jmp                 0xf

        $sequence_6 = { 6af4 58 e9???????? 7904 }
            // n = 4, score = 700
            //   6af4                 | push                -0xc
            //   58                   | pop                 eax
            //   e9????????           |                     
            //   7904                 | jns                 6

        $sequence_7 = { ff15???????? ff349f 8bf0 ff15???????? 3bf0 }
            // n = 5, score = 700
            //   ff15????????         |                     
            //   ff349f               | push                dword ptr [edi + ebx*4]
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   3bf0                 | cmp                 esi, eax

        $sequence_8 = { 7505 6ac4 58 eb2f }
            // n = 4, score = 700
            //   7505                 | jne                 7
            //   6ac4                 | push                -0x3c
            //   58                   | pop                 eax
            //   eb2f                 | jmp                 0x31

        $sequence_9 = { 7508 6af4 58 e9???????? 7904 6af6 }
            // n = 6, score = 700
            //   7508                 | jne                 0xa
            //   6af4                 | push                -0xc
            //   58                   | pop                 eax
            //   e9????????           |                     
            //   7904                 | jns                 6
            //   6af6                 | push                -0xa

    condition:
        7 of them and filesize < 327680
}