rule win_glooxmail_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.glooxmail."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.glooxmail"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d55c0 52 8d9564ffffff c645fc4a 8b01 52 ff5044 }
            // n = 7, score = 100
            //   8d55c0               | lea                 edx, [ebp - 0x40]
            //   52                   | push                edx
            //   8d9564ffffff         | lea                 edx, [ebp - 0x9c]
            //   c645fc4a             | mov                 byte ptr [ebp - 4], 0x4a
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   52                   | push                edx
            //   ff5044               | call                dword ptr [eax + 0x44]

        $sequence_1 = { e8???????? 385df3 7407 c745ec40000000 68???????? 8d8d7cffffff e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   385df3               | cmp                 byte ptr [ebp - 0xd], bl
            //   7407                 | je                  9
            //   c745ec40000000       | mov                 dword ptr [ebp - 0x14], 0x40
            //   68????????           |                     
            //   8d8d7cffffff         | lea                 ecx, [ebp - 0x84]
            //   e8????????           |                     

        $sequence_2 = { 6a01 8d8c24f0020000 81e3fff7ffff e8???????? f7c300040000 740f 56 }
            // n = 7, score = 100
            //   6a01                 | push                1
            //   8d8c24f0020000       | lea                 ecx, [esp + 0x2f0]
            //   81e3fff7ffff         | and                 ebx, 0xfffff7ff
            //   e8????????           |                     
            //   f7c300040000         | test                ebx, 0x400
            //   740f                 | je                  0x11
            //   56                   | push                esi

        $sequence_3 = { 8d4dd8 e9???????? 8b4d08 e9???????? 8b4508 054c040000 e9???????? }
            // n = 7, score = 100
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e9????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   e9????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   054c040000           | add                 eax, 0x44c
            //   e9????????           |                     

        $sequence_4 = { 814df000020000 68???????? 8d4db4 e8???????? 8d85b8feffff 50 8d45b4 }
            // n = 7, score = 100
            //   814df000020000       | or                  dword ptr [ebp - 0x10], 0x200
            //   68????????           |                     
            //   8d4db4               | lea                 ecx, [ebp - 0x4c]
            //   e8????????           |                     
            //   8d85b8feffff         | lea                 eax, [ebp - 0x148]
            //   50                   | push                eax
            //   8d45b4               | lea                 eax, [ebp - 0x4c]

        $sequence_5 = { 83a50cfffffff7 8d8d30feffff e9???????? c3 8d4db8 e9???????? 8d8dd8feffff }
            // n = 7, score = 100
            //   83a50cfffffff7       | and                 dword ptr [ebp - 0xf4], 0xfffffff7
            //   8d8d30feffff         | lea                 ecx, [ebp - 0x1d0]
            //   e9????????           |                     
            //   c3                   | ret                 
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   e9????????           |                     
            //   8d8dd8feffff         | lea                 ecx, [ebp - 0x128]

        $sequence_6 = { 8bfb e8???????? 33f6 33ff 56 47 57 }
            // n = 7, score = 100
            //   8bfb                 | mov                 edi, ebx
            //   e8????????           |                     
            //   33f6                 | xor                 esi, esi
            //   33ff                 | xor                 edi, edi
            //   56                   | push                esi
            //   47                   | inc                 edi
            //   57                   | push                edi

        $sequence_7 = { 895dcc f645d008 740e 8365d0f7 53 57 8d4d84 }
            // n = 7, score = 100
            //   895dcc               | mov                 dword ptr [ebp - 0x34], ebx
            //   f645d008             | test                byte ptr [ebp - 0x30], 8
            //   740e                 | je                  0x10
            //   8365d0f7             | and                 dword ptr [ebp - 0x30], 0xfffffff7
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8d4d84               | lea                 ecx, [ebp - 0x7c]

        $sequence_8 = { ff750c 83a424bc00000000 8d442430 50 e8???????? }
            // n = 5, score = 100
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   83a424bc00000000     | and                 dword ptr [esp + 0xbc], 0
            //   8d442430             | lea                 eax, [esp + 0x30]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_9 = { e8???????? c78424600800006d000000 f744241000000080 7417 81642410ffffff7f 53 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   c78424600800006d000000     | mov    dword ptr [esp + 0x860], 0x6d
            //   f744241000000080     | test                dword ptr [esp + 0x10], 0x80000000
            //   7417                 | je                  0x19
            //   81642410ffffff7f     | and                 dword ptr [esp + 0x10], 0x7fffffff
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 761856
}