rule win_glupteba_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.glupteba."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.glupteba"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 81e680800000 895de4 0bfe 8b75fc c1ee07 c1e709 }
            // n = 6, score = 400
            //   81e680800000         | and                 esi, 0x8080
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx
            //   0bfe                 | or                  edi, esi
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   c1ee07               | shr                 esi, 7
            //   c1e709               | shl                 edi, 9

        $sequence_1 = { 742f 68???????? 50 c705????????04000000 ff15???????? 833d????????04 }
            // n = 6, score = 400
            //   742f                 | je                  0x31
            //   68????????           |                     
            //   50                   | push                eax
            //   c705????????04000000     |     
            //   ff15????????         |                     
            //   833d????????04       |                     

        $sequence_2 = { 83c40c ff750c 66c745f00200 ff15???????? 668945f2 6a10 }
            // n = 6, score = 400
            //   83c40c               | add                 esp, 0xc
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   66c745f00200         | mov                 word ptr [ebp - 0x10], 2
            //   ff15????????         |                     
            //   668945f2             | mov                 word ptr [ebp - 0xe], ax
            //   6a10                 | push                0x10

        $sequence_3 = { ff15???????? 83c444 ff750c ff7508 e8???????? 8bf0 }
            // n = 6, score = 400
            //   ff15????????         |                     
            //   83c444               | add                 esp, 0x44
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_4 = { 68???????? 57 895d0c ff15???????? }
            // n = 4, score = 400
            //   68????????           |                     
            //   57                   | push                edi
            //   895d0c               | mov                 dword ptr [ebp + 0xc], ebx
            //   ff15????????         |                     

        $sequence_5 = { 8b4c2404 c1e802 d1e9 0ac1 8ac8 }
            // n = 5, score = 400
            //   8b4c2404             | mov                 ecx, dword ptr [esp + 4]
            //   c1e802               | shr                 eax, 2
            //   d1e9                 | shr                 ecx, 1
            //   0ac1                 | or                  al, cl
            //   8ac8                 | mov                 cl, al

        $sequence_6 = { 03c0 33c8 8bc1 3500630000 c1e808 33c1 }
            // n = 6, score = 400
            //   03c0                 | add                 eax, eax
            //   33c8                 | xor                 ecx, eax
            //   8bc1                 | mov                 eax, ecx
            //   3500630000           | xor                 eax, 0x6300
            //   c1e808               | shr                 eax, 8
            //   33c1                 | xor                 eax, ecx

        $sequence_7 = { 895f04 894f08 83c710 837d0824 897d0c 7285 8bf9 }
            // n = 7, score = 400
            //   895f04               | mov                 dword ptr [edi + 4], ebx
            //   894f08               | mov                 dword ptr [edi + 8], ecx
            //   83c710               | add                 edi, 0x10
            //   837d0824             | cmp                 dword ptr [ebp + 8], 0x24
            //   897d0c               | mov                 dword ptr [ebp + 0xc], edi
            //   7285                 | jb                  0xffffff87
            //   8bf9                 | mov                 edi, ecx

        $sequence_8 = { 005e3e 46 00ff 3e46 }
            // n = 4, score = 100
            //   005e3e               | add                 byte ptr [esi + 0x3e], bl
            //   46                   | inc                 esi
            //   00ff                 | add                 bh, bh
            //   3e46                 | inc                 esi

        $sequence_9 = { 00cd 3e46 005e3e 46 }
            // n = 4, score = 100
            //   00cd                 | add                 ch, cl
            //   3e46                 | inc                 esi
            //   005e3e               | add                 byte ptr [esi + 0x3e], bl
            //   46                   | inc                 esi

        $sequence_10 = { 0107 eb4d 8b02 89442418 }
            // n = 4, score = 100
            //   0107                 | add                 dword ptr [edi], eax
            //   eb4d                 | jmp                 0x4f
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   89442418             | mov                 dword ptr [esp + 0x18], eax

        $sequence_11 = { 00ff 3e46 0012 3f }
            // n = 4, score = 100
            //   00ff                 | add                 bh, bh
            //   3e46                 | inc                 esi
            //   0012                 | add                 byte ptr [edx], dl
            //   3f                   | aas                 

        $sequence_12 = { 0101 03d3 8b4620 8bcb }
            // n = 4, score = 100
            //   0101                 | add                 dword ptr [ecx], eax
            //   03d3                 | add                 edx, ebx
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   8bcb                 | mov                 ecx, ebx

        $sequence_13 = { 0106 830702 392e 75a0 }
            // n = 4, score = 100
            //   0106                 | add                 dword ptr [esi], eax
            //   830702               | add                 dword ptr [edi], 2
            //   392e                 | cmp                 dword ptr [esi], ebp
            //   75a0                 | jne                 0xffffffa2

        $sequence_14 = { 00f1 3d46005e3e 46 00cd }
            // n = 4, score = 100
            //   00f1                 | add                 cl, dh
            //   3d46005e3e           | cmp                 eax, 0x3e5e0046
            //   46                   | inc                 esi
            //   00cd                 | add                 ch, cl

        $sequence_15 = { 0012 3f 46 008bff558bec }
            // n = 4, score = 100
            //   0012                 | add                 byte ptr [edx], dl
            //   3f                   | aas                 
            //   46                   | inc                 esi
            //   008bff558bec         | add                 byte ptr [ebx - 0x1374aa01], cl

    condition:
        7 of them and filesize < 1417216
}