rule win_goggles_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.goggles."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.goggles"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 8d842488010000 6a00 50 ff15???????? }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   8d842488010000       | lea                 eax, [esp + 0x188]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_1 = { 52 68???????? ff15???????? 8a542b01 }
            // n = 4, score = 100
            //   52                   | push                edx
            //   68????????           |                     
            //   ff15????????         |                     
            //   8a542b01             | mov                 dl, byte ptr [ebx + ebp + 1]

        $sequence_2 = { 68???????? e8???????? 83c410 c680a841001000 8d842410010000 }
            // n = 5, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   c680a841001000       | mov                 byte ptr [eax + 0x100041a8], 0
            //   8d842410010000       | lea                 eax, [esp + 0x110]

        $sequence_3 = { 8a8010400010 88441efe 8a4c2fff 83e13f 4a 8a8110400010 88441eff }
            // n = 7, score = 100
            //   8a8010400010         | mov                 al, byte ptr [eax + 0x10004010]
            //   88441efe             | mov                 byte ptr [esi + ebx - 2], al
            //   8a4c2fff             | mov                 cl, byte ptr [edi + ebp - 1]
            //   83e13f               | and                 ecx, 0x3f
            //   4a                   | dec                 edx
            //   8a8110400010         | mov                 al, byte ptr [ecx + 0x10004010]
            //   88441eff             | mov                 byte ptr [esi + ebx - 1], al

        $sequence_4 = { 0f8559ffffff 8b442414 83f803 756e 0fbe0437 }
            // n = 5, score = 100
            //   0f8559ffffff         | jne                 0xffffff5f
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   83f803               | cmp                 eax, 3
            //   756e                 | jne                 0x70
            //   0fbe0437             | movsx               eax, byte ptr [edi + esi]

        $sequence_5 = { 33f6 894c240c 85c9 7e6f 8b4c2418 8bc2 2bc1 }
            // n = 7, score = 100
            //   33f6                 | xor                 esi, esi
            //   894c240c             | mov                 dword ptr [esp + 0xc], ecx
            //   85c9                 | test                ecx, ecx
            //   7e6f                 | jle                 0x71
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   8bc2                 | mov                 eax, edx
            //   2bc1                 | sub                 eax, ecx

        $sequence_6 = { 0fbe043e 50 68???????? ff15???????? b9???????? 2ac1 c0e002 }
            // n = 7, score = 100
            //   0fbe043e             | movsx               eax, byte ptr [esi + edi]
            //   50                   | push                eax
            //   68????????           |                     
            //   ff15????????         |                     
            //   b9????????           |                     
            //   2ac1                 | sub                 al, cl
            //   c0e002               | shl                 al, 2

        $sequence_7 = { 55 57 88442410 b940000000 33c0 8d7c2411 }
            // n = 6, score = 100
            //   55                   | push                ebp
            //   57                   | push                edi
            //   88442410             | mov                 byte ptr [esp + 0x10], al
            //   b940000000           | mov                 ecx, 0x40
            //   33c0                 | xor                 eax, eax
            //   8d7c2411             | lea                 edi, [esp + 0x11]

        $sequence_8 = { 8a4c2ffe c1f806 83e10f 83e003 c1e102 0bc1 8a8010400010 }
            // n = 7, score = 100
            //   8a4c2ffe             | mov                 cl, byte ptr [edi + ebp - 2]
            //   c1f806               | sar                 eax, 6
            //   83e10f               | and                 ecx, 0xf
            //   83e003               | and                 eax, 3
            //   c1e102               | shl                 ecx, 2
            //   0bc1                 | or                  eax, ecx
            //   8a8010400010         | mov                 al, byte ptr [eax + 0x10004010]

        $sequence_9 = { 0fbe8288410010 50 68???????? ff15???????? }
            // n = 4, score = 100
            //   0fbe8288410010       | movsx               eax, byte ptr [edx + 0x10004188]
            //   50                   | push                eax
            //   68????????           |                     
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 57344
}