rule win_golroted_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.golroted"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b450c 8b55ec e8???????? 33c0 }
            // n = 4, score = 600
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 8d442408 50 53 8b442414 50 56 }
            // n = 6, score = 600
            //   8d442408             | lea                 eax, [esp + 8]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_2 = { 84db 7467 6a64 e8???????? 8d55f0 33c0 }
            // n = 6, score = 600
            //   84db                 | test                bl, bl
            //   7467                 | je                  0x69
            //   6a64                 | push                0x64
            //   e8????????           |                     
            //   8d55f0               | lea                 edx, [ebp - 0x10]
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { b90a000000 80fb55 0f842af6ffff e9???????? 80f953 }
            // n = 5, score = 600
            //   b90a000000           | mov                 ecx, 0xa
            //   80fb55               | cmp                 bl, 0x55
            //   0f842af6ffff         | je                  0xfffff630
            //   e9????????           |                     
            //   80f953               | cmp                 cl, 0x53

        $sequence_4 = { 3d00140000 7d46 89c2 83e21f 8d1492 dbac532b304000 }
            // n = 6, score = 600
            //   3d00140000           | cmp                 eax, 0x1400
            //   7d46                 | jge                 0x48
            //   89c2                 | mov                 edx, eax
            //   83e21f               | and                 edx, 0x1f
            //   8d1492               | lea                 edx, [edx + edx*4]
            //   dbac532b304000       | fld                 xword ptr [ebx + edx*2 + 0x40302b]

        $sequence_5 = { e8???????? 84c0 748c 833c2400 7486 b891010000 }
            // n = 6, score = 600
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   748c                 | je                  0xffffff8e
            //   833c2400             | cmp                 dword ptr [esp], 0
            //   7486                 | je                  0xffffff88
            //   b891010000           | mov                 eax, 0x191

        $sequence_6 = { e8???????? 8b45f4 50 8d55ec 8b45f8 e8???????? 8b45ec }
            // n = 7, score = 600
            //   e8????????           |                     
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   50                   | push                eax
            //   8d55ec               | lea                 edx, [ebp - 0x14]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   e8????????           |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_7 = { 33c0 8945dc c645e000 8d4510 8945e4 c645e805 8b4514 }
            // n = 7, score = 600
            //   33c0                 | xor                 eax, eax
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   c645e000             | mov                 byte ptr [ebp - 0x20], 0
            //   8d4510               | lea                 eax, [ebp + 0x10]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   c645e805             | mov                 byte ptr [ebp - 0x18], 5
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]

        $sequence_8 = { 8b85e0feffff 99 030424 13542404 }
            // n = 4, score = 600
            //   8b85e0feffff         | mov                 eax, dword ptr [ebp - 0x120]
            //   99                   | cdq                 
            //   030424               | add                 eax, dword ptr [esp]
            //   13542404             | adc                 edx, dword ptr [esp + 4]

        $sequence_9 = { 8d45c8 50 68???????? e8???????? e9???????? 6a04 }
            // n = 6, score = 600
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   e9????????           |                     
            //   6a04                 | push                4

    condition:
        7 of them and filesize < 286720
}