rule win_goopic_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.goopic."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.goopic"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89742414 ff15???????? 50 ff15???????? 85c0 7427 }
            // n = 6, score = 100
            //   89742414             | mov                 dword ptr [esp + 0x14], esi
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7427                 | je                  0x29

        $sequence_1 = { 0f84c6000000 833d????????00 740d 8d85f0fdffff 50 }
            // n = 5, score = 100
            //   0f84c6000000         | je                  0xcc
            //   833d????????00       |                     
            //   740d                 | je                  0xf
            //   8d85f0fdffff         | lea                 eax, [ebp - 0x210]
            //   50                   | push                eax

        $sequence_2 = { 85c0 7411 e8???????? ba01000000 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13
            //   e8????????           |                     
            //   ba01000000           | mov                 edx, 1

        $sequence_3 = { c785d0fdffff2c020000 ff15???????? 8bf0 8d85d0fdffff 50 56 89b5ccfdffff }
            // n = 7, score = 100
            //   c785d0fdffff2c020000     | mov    dword ptr [ebp - 0x230], 0x22c
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   8d85d0fdffff         | lea                 eax, [ebp - 0x230]
            //   50                   | push                eax
            //   56                   | push                esi
            //   89b5ccfdffff         | mov                 dword ptr [ebp - 0x234], esi

        $sequence_4 = { 58 6bc000 c7803430400002000000 6a04 58 }
            // n = 5, score = 100
            //   58                   | pop                 eax
            //   6bc000               | imul                eax, eax, 0
            //   c7803430400002000000     | mov    dword ptr [eax + 0x403034], 2
            //   6a04                 | push                4
            //   58                   | pop                 eax

        $sequence_5 = { 68???????? 6a01 6a00 68???????? ff15???????? 85c0 0f888e000000 }
            // n = 7, score = 100
            //   68????????           |                     
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   68????????           |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f888e000000         | js                  0x94

        $sequence_6 = { be00010000 33c0 66c787000100000000 8801 8d4901 40 663bc6 }
            // n = 7, score = 100
            //   be00010000           | mov                 esi, 0x100
            //   33c0                 | xor                 eax, eax
            //   66c787000100000000     | mov    word ptr [edi + 0x100], 0
            //   8801                 | mov                 byte ptr [ecx], al
            //   8d4901               | lea                 ecx, [ecx + 1]
            //   40                   | inc                 eax
            //   663bc6               | cmp                 ax, si

        $sequence_7 = { ffd7 e8???????? e8???????? 8bd6 }
            // n = 4, score = 100
            //   ffd7                 | call                edi
            //   e8????????           |                     
            //   e8????????           |                     
            //   8bd6                 | mov                 edx, esi

        $sequence_8 = { b9???????? e8???????? 83c404 8d85f8dfffff }
            // n = 4, score = 100
            //   b9????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d85f8dfffff         | lea                 eax, [ebp - 0x2008]

        $sequence_9 = { c785c0fdffff305d4000 eb0a c785c0fdffff245d4000 8d85b4fdffff c785c4fdffff3c5d4000 50 }
            // n = 6, score = 100
            //   c785c0fdffff305d4000     | mov    dword ptr [ebp - 0x240], 0x405d30
            //   eb0a                 | jmp                 0xc
            //   c785c0fdffff245d4000     | mov    dword ptr [ebp - 0x240], 0x405d24
            //   8d85b4fdffff         | lea                 eax, [ebp - 0x24c]
            //   c785c4fdffff3c5d4000     | mov    dword ptr [ebp - 0x23c], 0x405d3c
            //   50                   | push                eax

    condition:
        7 of them and filesize < 114688
}