rule win_gooseegg_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gooseegg."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gooseegg"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4d85c9 488d3d797c0000 488bc2 4c8bfa 4d0f45d1 4885d2 418d6b01 }
            // n = 7, score = 100
            //   4d85c9               | lea                 ecx, [edx + ecx*8]
            //   488d3d797c0000       | mov                 edx, 0xfa0
            //   488bc2               | xor                 ebx, ebx
            //   4c8bfa               | dec                 eax
            //   4d0f45d1             | lea                 edx, [0x148ad]
            //   4885d2               | inc                 ebp
            //   418d6b01             | xor                 eax, eax

        $sequence_1 = { 488d05f1550100 c3 488d05f1550100 c3 4883ec28 e8???????? }
            // n = 6, score = 100
            //   488d05f1550100       | dec                 eax
            //   c3                   | lea                 edi, [0x7c79]
            //   488d05f1550100       | dec                 eax
            //   c3                   | mov                 eax, edx
            //   4883ec28             | dec                 esp
            //   e8????????           |                     

        $sequence_2 = { eb02 33db 4c8d357194ffff 4885db }
            // n = 4, score = 100
            //   eb02                 | mov                 ecx, dword ptr [esi + edi*8 + 0x17810]
            //   33db                 | dec                 eax
            //   4c8d357194ffff       | or                  edi, 0xffffffff
            //   4885db               | inc                 ecx

        $sequence_3 = { ff15???????? 48832300 4883c308 488d05b9440100 483bd8 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   48832300             | dec                 eax
            //   4883c308             | ror                 edx, cl
            //   488d05b9440100       | dec                 ecx
            //   483bd8               | xor                 edx, eax

        $sequence_4 = { 488d35abe70000 48895c2420 488d056fff0000 483bd8 7419 483933 740e }
            // n = 7, score = 100
            //   488d35abe70000       | pop                 edi
            //   48895c2420           | ret                 
            //   488d056fff0000       | dec                 eax
            //   483bd8               | mov                 dword ptr [esp + 8], ebx
            //   7419                 | push                edi
            //   483933               | dec                 eax
            //   740e                 | sub                 esp, 0x20

        $sequence_5 = { 488b05???????? 488d150ef7ffff 483bc2 7423 65488b042530000000 }
            // n = 5, score = 100
            //   488b05????????       |                     
            //   488d150ef7ffff       | dec                 eax
            //   483bc2               | mov                 edi, dword ptr [esp + 0x978]
            //   7423                 | dec                 eax
            //   65488b042530000000     | mov    dword ptr [ebp - 0x68], eax

        $sequence_6 = { 4c8d0dd17b0000 33c9 4c8d05c47b0000 488d15c57b0000 e8???????? 4885c0 740b }
            // n = 7, score = 100
            //   4c8d0dd17b0000       | dec                 eax
            //   33c9                 | mov                 esi, dword ptr [esp + 0x980]
            //   4c8d05c47b0000       | dec                 eax
            //   488d15c57b0000       | add                 esp, 0x960
            //   e8????????           |                     
            //   4885c0               | xor                 eax, eax
            //   740b                 | dec                 esp

        $sequence_7 = { 488945e0 895128 488d0dbb940000 488b45d8 488908 488d0d0d190100 488b45d8 }
            // n = 7, score = 100
            //   488945e0             | mov                 ebp, dword ptr [esp + 0x58]
            //   895128               | dec                 eax
            //   488d0dbb940000       | ror                 edi, cl
            //   488b45d8             | dec                 ecx
            //   488908               | xor                 edi, edx
            //   488d0d0d190100       | dec                 ebx
            //   488b45d8             | xchg                dword ptr [esi + edi*8 + 0x17330], edi

        $sequence_8 = { 8bfb e9???????? e8???????? 488d1df2370100 }
            // n = 4, score = 100
            //   8bfb                 | dec                 eax
            //   e9????????           |                     
            //   e8????????           |                     
            //   488d1df2370100       | sar                 esi, 6

        $sequence_9 = { 85c0 0f849e000000 4c8d051f330100 ba00020000 }
            // n = 4, score = 100
            //   85c0                 | sub                 edi, esi
            //   0f849e000000         | mov                 al, byte ptr [edi + ebx]
            //   4c8d051f330100       | mov                 byte ptr [ebx], al
            //   ba00020000           | dec                 eax

    condition:
        7 of them and filesize < 217088
}