rule win_gopuram_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gopuram."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gopuram"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d15a3cb0200 488d0d645c0500 e8???????? 488d15c4c60200 488bc8 488b5c2430 4883c420 }
            // n = 7, score = 100
            //   488d15a3cb0200       | mov                 dword ptr [ebp - 0x68], esp
            //   488d0d645c0500       | dec                 eax
            //   e8????????           |                     
            //   488d15c4c60200       | mov                 ecx, dword ptr [ebp - 0x60]
            //   488bc8               | dec                 eax
            //   488b5c2430           | test                ecx, ecx
            //   4883c420             | je                  0xc96

        $sequence_1 = { e8???????? 85c0 743e 488d157b930500 488bcf e8???????? 85c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | dec                 ecx
            //   743e                 | mov                 edx, dword ptr [ebx + 0x58]
            //   488d157b930500       | dec                 eax
            //   488bcf               | test                edx, edx
            //   e8????????           |                     
            //   85c0                 | je                  0x1a22

        $sequence_2 = { ff10 4c8bc7 ba10000000 488bcb e8???????? 488bc3 e9???????? }
            // n = 7, score = 100
            //   ff10                 | dec                 ebp
            //   4c8bc7               | test                ebx, ebx
            //   ba10000000           | jne                 0x1d39
            //   488bcb               | call                dword ptr [eax + 0x40]
            //   e8????????           |                     
            //   488bc3               | test                eax, eax
            //   e9????????           |                     

        $sequence_3 = { 7e1c 4183ff09 0f8eae000000 4183ff0a 750c 488d05833c0500 4889442450 }
            // n = 7, score = 100
            //   7e1c                 | inc                 ebp
            //   4183ff09             | test                esi, esi
            //   0f8eae000000         | jne                 0x1f3d
            //   4183ff0a             | inc                 ebp
            //   750c                 | test                edi, edi
            //   488d05833c0500       | jne                 0x1f3d
            //   4889442450           | test                edi, edi

        $sequence_4 = { e8???????? 488d5606 488d4da8 41b802000000 66448965bc e8???????? 488d560c }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d5606             | mov                 ebx, dword ptr [ebp + 0xf0]
            //   488d4da8             | dec                 eax
            //   41b802000000         | mov                 ebx, dword ptr [ebp + 0xf8]
            //   66448965bc           | dec                 eax
            //   e8????????           |                     
            //   488d560c             | mov                 ebx, dword ptr [ebp + 0x100]

        $sequence_5 = { 8be8 85ed 0f842f010000 488b5c2470 488d8b18010000 ff15???????? 498b06 }
            // n = 7, score = 100
            //   8be8                 | mov                 eax, dword ptr [ecx]
            //   85ed                 | dec                 eax
            //   0f842f010000         | jmp                 dword ptr [eax + 0x48]
            //   488b5c2470           | ret                 
            //   488d8b18010000       | dec                 eax
            //   ff15????????         |                     
            //   498b06               | mov                 ecx, dword ptr [ecx + 0x28]

        $sequence_6 = { 8bd8 e8???????? 4c8d05df1e0800 41b9de010000 8bd7 498bce c744242000000000 }
            // n = 7, score = 100
            //   8bd8                 | jmp                 0x190
            //   e8????????           |                     
            //   4c8d05df1e0800       | mov                 edi, 1
            //   41b9de010000         | mov                 edx, ebx
            //   8bd7                 | dec                 ecx
            //   498bce               | mov                 ecx, esi
            //   c744242000000000     | jmp                 0x198

        $sequence_7 = { 85f6 0f8486050000 488b85600a0000 4889442440 c744242801000000 48895c2420 4533c9 }
            // n = 7, score = 100
            //   85f6                 | dec                 ecx
            //   0f8486050000         | mov                 ecx, esp
            //   488b85600a0000       | call                dword ptr [eax + 0x130]
            //   4889442440           | dec                 eax
            //   c744242801000000     | mov                 ecx, eax
            //   48895c2420           | dec                 eax
            //   4533c9               | mov                 edx, dword ptr [eax]

        $sequence_8 = { c705????????03400080 c705????????f4060780 890d???????? c705????????09000380 418bc4 413b7ffc 750d }
            // n = 7, score = 100
            //   c705????????03400080     |     
            //   c705????????f4060780     |     
            //   890d????????         |                     
            //   c705????????09000380     |     
            //   418bc4               | dec                 eax
            //   413b7ffc             | mov                 ecx, esi
            //   750d                 | inc                 esp

        $sequence_9 = { 488bcd e8???????? 8bf8 85c0 782a 498bd6 488bcd }
            // n = 7, score = 100
            //   488bcd               | dec                 ecx
            //   e8????????           |                     
            //   8bf8                 | mov                 dword ptr [ebp + ecx*8], eax
            //   85c0                 | dec                 eax
            //   782a                 | inc                 ecx
            //   498bd6               | dec                 eax
            //   488bcd               | add                 edx, 0x58

    condition:
        7 of them and filesize < 1591296
}