rule win_grabbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.grabbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grabbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f85a 770b 83f841 7206 83c020 0fb7c0 83c202 }
            // n = 7, score = 3300
            //   83f85a               | cmp                 eax, 0x5a
            //   770b                 | ja                  0xd
            //   83f841               | cmp                 eax, 0x41
            //   7206                 | jb                  8
            //   83c020               | add                 eax, 0x20
            //   0fb7c0               | movzx               eax, ax
            //   83c202               | add                 edx, 2

        $sequence_1 = { 83f85a 770d 83f841 7208 83c020 }
            // n = 5, score = 3300
            //   83f85a               | cmp                 eax, 0x5a
            //   770d                 | ja                  0xf
            //   83f841               | cmp                 eax, 0x41
            //   7208                 | jb                  0xa
            //   83c020               | add                 eax, 0x20

        $sequence_2 = { 50 6a04 ff75e8 ff75dc }
            // n = 4, score = 3200
            //   50                   | push                eax
            //   6a04                 | push                4
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   ff75dc               | push                dword ptr [ebp - 0x24]

        $sequence_3 = { 813850450000 7523 0fb75004 bb64860000 663bd3 7506 }
            // n = 6, score = 3200
            //   813850450000         | cmp                 dword ptr [eax], 0x4550
            //   7523                 | jne                 0x25
            //   0fb75004             | movzx               edx, word ptr [eax + 4]
            //   bb64860000           | mov                 ebx, 0x8664
            //   663bd3               | cmp                 dx, bx
            //   7506                 | jne                 8

        $sequence_4 = { b905000000 3907 7707 83c704 e2f7 }
            // n = 5, score = 3200
            //   b905000000           | mov                 ecx, 5
            //   3907                 | cmp                 dword ptr [edi], eax
            //   7707                 | ja                  9
            //   83c704               | add                 edi, 4
            //   e2f7                 | loop                0xfffffff9

        $sequence_5 = { 663907 7566 8b473c 03c7 813850450000 }
            // n = 5, score = 3200
            //   663907               | cmp                 word ptr [edi], ax
            //   7566                 | jne                 0x68
            //   8b473c               | mov                 eax, dword ptr [edi + 0x3c]
            //   03c7                 | add                 eax, edi
            //   813850450000         | cmp                 dword ptr [eax], 0x4550

        $sequence_6 = { c3 68d0035c09 e8???????? 50 e8???????? ffe0 }
            // n = 6, score = 3200
            //   c3                   | ret                 
            //   68d0035c09           | push                0x95c03d0
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   ffe0                 | jmp                 eax

        $sequence_7 = { e8???????? 59 81c480000000 50 8bf1 e8???????? e8???????? }
            // n = 7, score = 3200
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   81c480000000         | add                 esp, 0x80
            //   50                   | push                eax
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_8 = { 56 ffd0 33c9 66894c37fe }
            // n = 4, score = 2600
            //   56                   | push                esi
            //   ffd0                 | call                eax
            //   33c9                 | xor                 ecx, ecx
            //   66894c37fe           | mov                 word ptr [edi + esi - 2], cx

        $sequence_9 = { 7428 8b0d???????? 8908 8b0d???????? 894804 8b0d???????? }
            // n = 6, score = 2300
            //   7428                 | je                  0x2a
            //   8b0d????????         |                     
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8b0d????????         |                     
            //   894804               | mov                 dword ptr [eax + 4], ecx
            //   8b0d????????         |                     

        $sequence_10 = { 894808 8b0d???????? 89480c e9???????? 33c0 }
            // n = 5, score = 2300
            //   894808               | mov                 dword ptr [eax + 8], ecx
            //   8b0d????????         |                     
            //   89480c               | mov                 dword ptr [eax + 0xc], ecx
            //   e9????????           |                     
            //   33c0                 | xor                 eax, eax

        $sequence_11 = { 8d45f0 99 52 50 8b451c 99 }
            // n = 6, score = 2000
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   99                   | cdq                 
            //   52                   | push                edx
            //   50                   | push                eax
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]
            //   99                   | cdq                 

        $sequence_12 = { 57 8d7c000c 57 e8???????? }
            // n = 4, score = 2000
            //   57                   | push                edi
            //   8d7c000c             | lea                 edi, [eax + eax + 0xc]
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_13 = { e8???????? 85c0 56 0f9fc3 e8???????? 83c414 }
            // n = 6, score = 2000
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   56                   | push                esi
            //   0f9fc3               | setg                bl
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14

        $sequence_14 = { 50 ff15???????? a3???????? 85c0 7505 83c8ff }
            // n = 6, score = 2000
            //   50                   | push                eax
            //   ff15????????         |                     
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_15 = { 8bf0 85f6 741d 8d4601 }
            // n = 4, score = 2000
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   741d                 | je                  0x1f
            //   8d4601               | lea                 eax, [esi + 1]

    condition:
        7 of them and filesize < 1335296
}