rule win_grager_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.grager."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grager"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48898534020000 4c8bc7 89853c020000 8b83d0200000 898520020000 c7852402000004000010 }
            // n = 6, score = 100
            //   48898534020000       | mul                 ecx
            //   4c8bc7               | mov                 eax, edx
            //   89853c020000         | dec                 eax
            //   8b83d0200000         | lea                 edx, [0xfffe2117]
            //   898520020000         | test                ecx, ecx
            //   c7852402000004000010     | jne    0xdae

        $sequence_1 = { 4c8d35a5e6ffff 0f1f440000 84c9 0f84d1010000 48ffc7 }
            // n = 5, score = 100
            //   4c8d35a5e6ffff       | add                 eax, 0x208
            //   0f1f440000           | dec                 ecx
            //   84c9                 | mov                 ecx, esi
            //   0f84d1010000         | dec                 eax
            //   48ffc7               | mov                 dword ptr [esp + 0x20], eax

        $sequence_2 = { bb01000000 e9???????? 8b4a08 33db 488bbfc8050000 81c113fcffff 488b7218 }
            // n = 7, score = 100
            //   bb01000000           | dec                 eax
            //   e9????????           |                     
            //   8b4a08               | mov                 dword ptr [ebp + 0x2380], eax
            //   33db                 | dec                 esp
            //   488bbfc8050000       | mov                 esi, edx
            //   81c113fcffff         | dec                 esp
            //   488b7218             | mov                 ebp, ecx

        $sequence_3 = { 48890b 488d5308 488d4808 0f1102 e8???????? 488d058cdb0100 }
            // n = 6, score = 100
            //   48890b               | lea                 ebp, [0x15dce]
            //   488d5308             | jae                 0x348
            //   488d4808             | dec                 eax
            //   0f1102               | mov                 eax, ebx
            //   e8????????           |                     
            //   488d058cdb0100       | dec                 eax

        $sequence_4 = { 0fb605???????? 88814e050000 33c0 89814f050000 888153050000 33ff 4889b958050000 }
            // n = 7, score = 100
            //   0fb605????????       |                     
            //   88814e050000         | je                  0x1c6
            //   33c0                 | movzx               eax, byte ptr [ecx]
            //   89814f050000         | test                al, al
            //   888153050000         | je                  0x160
            //   33ff                 | dec                 eax
            //   4889b958050000       | mov                 ecx, eax

        $sequence_5 = { 488bf9 488d1584a10100 b904000000 e8???????? 8bd3 488bcf }
            // n = 6, score = 100
            //   488bf9               | dec                 esp
            //   488d1584a10100       | lea                 edi, [0x1880c]
            //   b904000000           | inc                 ecx
            //   e8????????           |                     
            //   8bd3                 | mov                 esi, 4
            //   488bcf               | inc                 esp

        $sequence_6 = { 4c8d0d45c80000 f20f101d???????? f20f100d???????? f20f59da }
            // n = 4, score = 100
            //   4c8d0d45c80000       | dec                 eax
            //   f20f101d????????     |                     
            //   f20f100d????????     |                     
            //   f20f59da             | mov                 ecx, ebx

        $sequence_7 = { 4c8bc3 8d040e 488d8d44030000 898540030000 e8???????? 488d0dd61bfeff }
            // n = 6, score = 100
            //   4c8bc3               | dec                 eax
            //   8d040e               | mov                 dword ptr [ebp - 0x78], 7
            //   488d8d44030000       | inc                 sp
            //   898540030000         | mov                 dword ptr [esp + 0x70], edi
            //   e8????????           |                     
            //   488d0dd61bfeff       | dec                 eax

        $sequence_8 = { 5d c3 8bc7 4883c470 415f 415e 415c }
            // n = 7, score = 100
            //   5d                   | cmp                 cx, dx
            //   c3                   | jne                 0x8f4
            //   8bc7                 | cmp                 word ptr [ebp - 0x80], 0
            //   4883c470             | je                  0x9eb
            //   415f                 | je                  0xa12
            //   415e                 | inc                 esp
            //   415c                 | mov                 eax, dword ptr [edx + 8]

        $sequence_9 = { 4883ec20 8bd9 4c8d0d21eb0000 b904000000 4c8d050deb0000 488d1586c20000 e8???????? }
            // n = 7, score = 100
            //   4883ec20             | inc                 ebx
            //   8bd9                 | mov                 dword ptr [ebp - 0x65], ebx
            //   4c8d0d21eb0000       | inc                 edx
            //   b904000000           | mov                 byte ptr [ecx + esi*8 + 0x3e], al
            //   4c8d050deb0000       | dec                 ebx
            //   488d1586c20000       | mov                 eax, dword ptr [eax + 0x35bd0]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 487424
}