rule win_grapeloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.grapeloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grapeloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 88542417 48894c2408 48c7042400000000 48833c2414 731e 8a542417 }
            // n = 6, score = 100
            //   88542417             | dec                 esp
            //   48894c2408           | lea                 eax, [0x11ad0]
            //   48c7042400000000     | dec                 eax
            //   48833c2414           | mov                 eax, ecx
            //   731e                 | and                 ecx, 0x3f
            //   8a542417             | dec                 eax

        $sequence_1 = { 0fbe4c2429 0fb7442410 01c8 6689442410 0fb644241b 0faf442420 89442420 }
            // n = 7, score = 100
            //   0fbe4c2429           | xchg                dword ptr [edi + edi*8 + 0x2b340], esi
            //   0fb7442410           | xor                 eax, eax
            //   01c8                 | dec                 eax
            //   6689442410           | mov                 ebx, dword ptr [esp + 0x50]
            //   0fb644241b           | dec                 eax
            //   0faf442420           | mov                 ebp, dword ptr [esp + 0x58]
            //   89442420             | dec                 ecx

        $sequence_2 = { eb00 488b8580000000 4889e1 488d95c4020000 48895120 48c7c1ffffffff 488d95d0020000 }
            // n = 7, score = 100
            //   eb00                 | dec                 eax
            //   488b8580000000       | lea                 ebp, [edx + 0x80]
            //   4889e1               | dec                 eax
            //   488d95c4020000       | lea                 ecx, [ebp + 0x628]
            //   48895120             | nop                 
            //   48c7c1ffffffff       | dec                 eax
            //   488d95d0020000       | mov                 dword ptr [esp + 0x10], edx

        $sequence_3 = { 5b c3 4883ec28 4c8d0d85b60000 33c9 4c8d0578b60000 488d1579b60000 }
            // n = 7, score = 100
            //   5b                   | mov                 dword ptr [esp + 0x3c], eax
            //   c3                   | jge                 0x146
            //   4883ec28             | mov                 dword ptr [esp + 0x24], 0x5f812184
            //   4c8d0d85b60000       | movzx               eax, byte ptr [esp + 0x2e]
            //   33c9                 | add                 eax, 0x2191
            //   4c8d0578b60000       | mov                 byte ptr [esp + 0x2e], al
            //   488d1579b60000       | movzx               ecx, byte ptr [esp + 0x2f]

        $sequence_4 = { 4883ec38 4889542430 48894c2428 488b4c2428 48894c2420 48c7015c000000 }
            // n = 6, score = 100
            //   4883ec38             | mov                 ecx, dword ptr [esp + 0x24]
            //   4889542430           | movzx               eax, byte ptr [esp + 0x1b]
            //   48894c2428           | sub                 eax, ecx
            //   488b4c2428           | mov                 byte ptr [esp + 0x1b], al
            //   48894c2420           | mov                 eax, dword ptr [esp + 0x14]
            //   48c7015c000000       | mov                 ecx, dword ptr [esp + 0x24]

        $sequence_5 = { 03442438 89442438 0fb744243c 05876c0000 668944243c 8b442438 03442424 }
            // n = 7, score = 100
            //   03442438             | movzx               ecx, word ptr [ebp + 0x32e]
            //   89442438             | dec                 eax
            //   0fb744243c           | lea                 ecx, [ecx + ecx*4]
            //   05876c0000           | dec                 eax
            //   668944243c           | lea                 eax, [eax + ecx*8 + 0x18]
            //   8b442438             | dec                 eax
            //   03442424             | mov                 eax, dword ptr [ebp + 0x140]

        $sequence_6 = { 29c8 88442413 0fbf44243a 69c0be000000 668944243a 0fbf4c243a }
            // n = 6, score = 100
            //   29c8                 | mov                 byte ptr [esp + 0x35], al
            //   88442413             | mov                 byte ptr [esp + 0x34], al
            //   0fbf44243a           | mov                 byte ptr [esp + 0xa], 0xaf
            //   69c0be000000         | movzx               eax, byte ptr [esp + 0x34]
            //   668944243a           | sub                 eax, 0x987476af
            //   0fbf4c243a           | mov                 byte ptr [esp + 0x34], al

        $sequence_7 = { 4889442428 f6401c01 7412 488b4c2428 c6411c00 4883c108 e8???????? }
            // n = 7, score = 100
            //   4889442428           | add                 eax, ecx
            //   f6401c01             | mov                 byte ptr [esp + 0x3a], al
            //   7412                 | movsx               eax, byte ptr [esp + 0x2f]
            //   488b4c2428           | mov                 byte ptr [esp + 0x3a], al
            //   c6411c00             | mov                 dword ptr [esp + 0x34], 0x23854b75
            //   4883c108             | movzx               ecx, byte ptr [esp + 0x3f]
            //   e8????????           |                     

        $sequence_8 = { 488d8d08030000 e8???????? 488d8d38030000 e8???????? c7850003000000000000 488d8ddf020000 }
            // n = 6, score = 100
            //   488d8d08030000       | mov                 word ptr [esp + 0x2e], ax
            //   e8????????           |                     
            //   488d8d38030000       | movzx               eax, word ptr [esp + 0x2c]
            //   e8????????           |                     
            //   c7850003000000000000     | sub    eax, 0xabb4c75c
            //   488d8ddf020000       | mov                 word ptr [esp + 0x2c], ax

        $sequence_9 = { eb00 488b9590010000 488b8d80010000 e8???????? 48898578010000 eb00 }
            // n = 6, score = 100
            //   eb00                 | dec                 eax
            //   488b9590010000       | add                 eax, 1
            //   488b8d80010000       | dec                 eax
            //   e8????????           |                     
            //   48898578010000       | mov                 dword ptr [esp], eax
            //   eb00                 | dec                 eax

    condition:
        7 of them and filesize < 397312
}