rule win_graphite_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.graphite."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.graphite"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85db 7513 33d2 e8???????? 84c0 }
            // n = 5, score = 500
            //   85db                 | dec                 eax
            //   7513                 | mov                 ecx, dword ptr [ebp - 0x28]
            //   33d2                 | dec                 ecx
            //   e8????????           |                     
            //   84c0                 | mov                 dword ptr [esi + 8], eax

        $sequence_1 = { 7513 33d2 e8???????? 84c0 }
            // n = 4, score = 500
            //   7513                 | dec                 eax
            //   33d2                 | mov                 ebx, eax
            //   e8????????           |                     
            //   84c0                 | dec                 ebp

        $sequence_2 = { 81e2ff030000 81e1bf030000 83c940 c1e10a }
            // n = 4, score = 500
            //   81e2ff030000         | push                esi
            //   81e1bf030000         | push                dword ptr [esp + 0x20]
            //   83c940               | call                ebp
            //   c1e10a               | push                esi

        $sequence_3 = { 81e2ff030000 81e1bf030000 83c940 c1e10a 0bca }
            // n = 5, score = 500
            //   81e2ff030000         | dec                 esp
            //   81e1bf030000         | mov                 ebx, eax
            //   83c940               | dec                 eax
            //   c1e10a               | test                eax, eax
            //   0bca                 | dec                 eax

        $sequence_4 = { 85db 7513 33d2 e8???????? }
            // n = 4, score = 500
            //   85db                 | push                0x6d
            //   7513                 | mov                 word ptr [ebp - 4], 0xe9f4
            //   33d2                 | mov                 byte ptr [ebp - 2], 0xe2
            //   e8????????           |                     

        $sequence_5 = { 81e1bf030000 83c940 c1e10a 0bca }
            // n = 4, score = 500
            //   81e1bf030000         | push                edi
            //   83c940               | push                esi
            //   c1e10a               | push                dword ptr [esp + 0x1c]
            //   0bca                 | mov                 esi, edi

        $sequence_6 = { 85db 7513 33d2 e8???????? 84c0 74e4 }
            // n = 6, score = 500
            //   85db                 | jne                 0x53b
            //   7513                 | push                ecx
            //   33d2                 | and                 dword ptr [ebp - 8], 0
            //   e8????????           |                     
            //   84c0                 | mov                 eax, dword ptr [ebp + 8]
            //   74e4                 | mov                 dword ptr [ebp - 4], eax

        $sequence_7 = { 7513 33d2 e8???????? 84c0 74e4 }
            // n = 5, score = 500
            //   7513                 | dec                 eax
            //   33d2                 | test                eax, eax
            //   e8????????           |                     
            //   84c0                 | je                  0x5cf
            //   74e4                 | dec                 eax

        $sequence_8 = { 33d2 e8???????? 84c0 74e4 }
            // n = 4, score = 500
            //   33d2                 | inc                 esp
            //   e8????????           |                     
            //   84c0                 | mov                 eax, ebx
            //   74e4                 | dec                 ecx

        $sequence_9 = { ff15???????? 33c0 eb05 b801010000 }
            // n = 4, score = 500
            //   ff15????????         |                     
            //   33c0                 | mov                 dword ptr [ebp - 0x44], 0x570b5732
            //   eb05                 | mov                 dword ptr [ebp - 0x50], 0xd7b8d794
            //   b801010000           | mov                 dword ptr [ebp - 0x4c], 0xd7a3d7b9

    condition:
        7 of them and filesize < 98304
}