rule win_graphsteel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.graphsteel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.graphsteel"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c3 488d0584215d00 bb10000000 e8???????? 4889f8 b900200000 e8???????? }
            // n = 7, score = 100
            //   c3                   | dec                 eax
            //   488d0584215d00       | lea                 eax, [0x4afece]
            //   bb10000000           | dec                 eax
            //   e8????????           |                     
            //   4889f8               | mov                 ebp, dword ptr [esp + 0xa0]
            //   b900200000           | dec                 eax
            //   e8????????           |                     

        $sequence_1 = { 8b842490000000 85c0 0f84e8feffff 488d4c2470 e8???????? 4489e0 4881c4b0000000 }
            // n = 7, score = 100
            //   8b842490000000       | cmp                 dl, 0x9f
            //   85c0                 | ja                  0x750
            //   0f84e8feffff         | inc                 ecx
            //   488d4c2470           | add                 edx, -0x70
            //   e8????????           |                     
            //   4489e0               | inc                 ebp
            //   4881c4b0000000       | lea                 ebx, [edx + 0x5f]

        $sequence_2 = { 664189856c010000 498b8528010000 4885c0 7407 c7401807000000 4c89e9 4531e4 }
            // n = 7, score = 100
            //   664189856c010000     | cmp                 al, 0xae
            //   498b8528010000       | je                  0xa03
            //   4885c0               | cmp                 al, 0x88
            //   7407                 | movzx               eax, byte ptr [edx]
            //   c7401807000000       | cmp                 al, 0xad
            //   4c89e9               | jne                 0x83b
            //   4531e4               | movzx               eax, byte ptr [edx + 2]

        $sequence_3 = { e8???????? 660f1f840000000000 4885c9 0f8425040000 48f7c160000000 7404 31d2 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   660f1f840000000000     | dec    eax
            //   4885c9               | lea                 eax, [0x5cee5c]
            //   0f8425040000         | mov                 ebx, 0x20
            //   48f7c160000000       | dec                 eax
            //   7404                 | lea                 eax, [0x5d2344]
            //   31d2                 | mov                 ebx, 0x26

        $sequence_4 = { ff15???????? 807e6900 7472 8b4628 85c0 7e4e 31db }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   807e6900             | jne                 0x131b
            //   7472                 | dec                 ecx
            //   8b4628               | mov                 eax, dword ptr [edi]
            //   85c0                 | dec                 eax
            //   7e4e                 | lea                 edx, [esp + 0x48]
            //   31db                 | inc                 ebp

        $sequence_5 = { e9???????? 488d7101 4839f7 732b 488d0533c23600 e8???????? 488d7301 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d7101             | dec                 eax
            //   4839f7               | lea                 ecx, [0x360de5]
            //   732b                 | dec                 eax
            //   488d0533c23600       | mov                 dword ptr [eax], ecx
            //   e8????????           |                     
            //   488d7301             | nop                 

        $sequence_6 = { 488d6c2430 48897c2420 48894c2450 48895c2448 4889442428 488d05cd4f4b00 e8???????? }
            // n = 7, score = 100
            //   488d6c2430           | lea                 eax, [0x32aee0]
            //   48897c2420           | dec                 eax
            //   48894c2450           | mov                 dword ptr [esp + 0xbf0], ecx
            //   48895c2448           | dec                 eax
            //   4889442428           | lea                 eax, [0x32e7cd]
            //   488d05cd4f4b00       | dec                 eax
            //   e8????????           |                     

        $sequence_7 = { eb0c 488d3d1e448600 e8???????? 488b0d???????? 48898c24f0020000 488d0533115500 e8???????? }
            // n = 7, score = 100
            //   eb0c                 | jne                 0x1f02
            //   488d3d1e448600       | dec                 eax
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   48898c24f0020000     | lea                 ecx, [0x5814f0]
            //   488d0533115500       | dec                 eax
            //   e8????????           |                     

        $sequence_8 = { 90 488b5c2468 488b4c2470 488d3d96682100 4889c6 4531c0 4531c9 }
            // n = 7, score = 100
            //   90                   | dec                 eax
            //   488b5c2468           | mov                 eax, dword ptr [ebx]
            //   488b4c2470           | dec                 eax
            //   488d3d96682100       | mov                 edx, dword ptr [ebx + 8]
            //   4889c6               | dec                 esp
            //   4531c0               | mov                 ecx, dword ptr [ebx + 0x10]
            //   4531c9               | dec                 esp

        $sequence_9 = { bb1a000000 e8???????? 0f1f440000 e8???????? 488d0594745400 488d1d8deb6400 e8???????? }
            // n = 7, score = 100
            //   bb1a000000           | mov                 edi, 1
            //   e8????????           |                     
            //   0f1f440000           | dec                 eax
            //   e8????????           |                     
            //   488d0594745400       | mov                 esi, edi
            //   488d1d8deb6400       | inc                 esp
            //   e8????????           |                     

    condition:
        7 of them and filesize < 19812352
}