rule win_gratem_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gratem."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gratem"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 55 8bec 8b4508 56 8d34c5c0b84000 833e00 7513 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   56                   | push                esi
            //   8d34c5c0b84000       | lea                 esi, [eax*8 + 0x40b8c0]
            //   833e00               | cmp                 dword ptr [esi], 0
            //   7513                 | jne                 0x15

        $sequence_1 = { c6040400 8d1424 52 ff15???????? 8b8c2408010000 33cc }
            // n = 6, score = 100
            //   c6040400             | mov                 byte ptr [esp + eax], 0
            //   8d1424               | lea                 edx, [esp]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b8c2408010000       | mov                 ecx, dword ptr [esp + 0x108]
            //   33cc                 | xor                 ecx, esp

        $sequence_2 = { 8945fc 85c0 742f 8b0e 8b5710 51 52 }
            // n = 7, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   85c0                 | test                eax, eax
            //   742f                 | je                  0x31
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   8b5710               | mov                 edx, dword ptr [edi + 0x10]
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_3 = { 0fb7048d64bc4000 41 6685c0 75e4 32c0 88460f c3 }
            // n = 7, score = 100
            //   0fb7048d64bc4000     | movzx               eax, word ptr [ecx*4 + 0x40bc64]
            //   41                   | inc                 ecx
            //   6685c0               | test                ax, ax
            //   75e4                 | jne                 0xffffffe6
            //   32c0                 | xor                 al, al
            //   88460f               | mov                 byte ptr [esi + 0xf], al
            //   c3                   | ret                 

        $sequence_4 = { ff15???????? 8945fc 85c0 742f 8b0e }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   85c0                 | test                eax, eax
            //   742f                 | je                  0x31
            //   8b0e                 | mov                 ecx, dword ptr [esi]

        $sequence_5 = { 0fb6c0 eb12 8b45e0 8a803cb44000 08443b1d }
            // n = 5, score = 100
            //   0fb6c0               | movzx               eax, al
            //   eb12                 | jmp                 0x14
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8a803cb44000         | mov                 al, byte ptr [eax + 0x40b43c]
            //   08443b1d             | or                  byte ptr [ebx + edi + 0x1d], al

        $sequence_6 = { 663bc2 0f84e6020000 0fb7048d64bc4000 41 6685c0 }
            // n = 5, score = 100
            //   663bc2               | cmp                 ax, dx
            //   0f84e6020000         | je                  0x2ec
            //   0fb7048d64bc4000     | movzx               eax, word ptr [ecx*4 + 0x40bc64]
            //   41                   | inc                 ecx
            //   6685c0               | test                ax, ax

        $sequence_7 = { 0fb7c0 baa3170000 663bc2 0f84e6020000 0fb7048d64bc4000 41 6685c0 }
            // n = 7, score = 100
            //   0fb7c0               | movzx               eax, ax
            //   baa3170000           | mov                 edx, 0x17a3
            //   663bc2               | cmp                 ax, dx
            //   0f84e6020000         | je                  0x2ec
            //   0fb7048d64bc4000     | movzx               eax, word ptr [ecx*4 + 0x40bc64]
            //   41                   | inc                 ecx
            //   6685c0               | test                ax, ax

        $sequence_8 = { 0f84de030000 0fb7048d64bc4000 41 6685c0 75e4 }
            // n = 5, score = 100
            //   0f84de030000         | je                  0x3e4
            //   0fb7048d64bc4000     | movzx               eax, word ptr [ecx*4 + 0x40bc64]
            //   41                   | inc                 ecx
            //   6685c0               | test                ax, ax
            //   75e4                 | jne                 0xffffffe6

        $sequence_9 = { 0f8469010000 0fb7048d64bc4000 41 6685c0 75e4 }
            // n = 5, score = 100
            //   0f8469010000         | je                  0x16f
            //   0fb7048d64bc4000     | movzx               eax, word ptr [ecx*4 + 0x40bc64]
            //   41                   | inc                 ecx
            //   6685c0               | test                ax, ax
            //   75e4                 | jne                 0xffffffe6

    condition:
        7 of them and filesize < 155648
}