rule win_grease_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.grease."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grease"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 50 683f000f00 50 50 50 }
            // n = 6, score = 400
            //   52                   | push                edx
            //   50                   | push                eax
            //   683f000f00           | push                0xf003f
            //   50                   | push                eax
            //   50                   | push                eax
            //   50                   | push                eax

        $sequence_1 = { 4053 4881ec90020000 488b05???????? 4833c4 4889842480020000 488d4c2472 }
            // n = 6, score = 300
            //   4053                 | xor                 eax, eax
            //   4881ec90020000       | mov                 dword ptr [esp + 0x28], 0xf003f
            //   488b05????????       |                     
            //   4833c4               | mov                 dword ptr [esp + 0x20], edi
            //   4889842480020000     | test                eax, eax
            //   488d4c2472           | mov                 dword ptr [esp + 0x20], ebx

        $sequence_2 = { 4889442438 48897c2430 4533c0 c74424283f000f00 897c2420 ff15???????? 85c0 }
            // n = 7, score = 300
            //   4889442438           | inc                 ecx
            //   48897c2430           | mov                 ecx, 4
            //   4533c0               | inc                 ebp
            //   c74424283f000f00     | xor                 eax, eax
            //   897c2420             | dec                 eax
            //   ff15????????         |                     
            //   85c0                 | mov                 dword ptr [esp + 0x38], eax

        $sequence_3 = { 895c2420 ff15???????? 85c0 0f85e7000000 }
            // n = 4, score = 300
            //   895c2420             | dec                 eax
            //   ff15????????         |                     
            //   85c0                 | mov                 dword ptr [esp + 0x30], edi
            //   0f85e7000000         | inc                 ebp

        $sequence_4 = { 488b4c2460 ff15???????? b801000000 488b8c2480020000 4833cc e8???????? 4881c490020000 }
            // n = 7, score = 300
            //   488b4c2460           | lea                 ecx, [esp + 0x72]
            //   ff15????????         |                     
            //   b801000000           | dec                 eax
            //   488b8c2480020000     | mov                 ecx, dword ptr [esp + 0x50]
            //   4833cc               | dec                 eax
            //   e8????????           |                     
            //   4881c490020000       | lea                 eax, [esp + 0x58]

        $sequence_5 = { 4533c0 488bd3 c744242804000000 4889442420 ff15???????? 488b4c2450 ff15???????? }
            // n = 7, score = 300
            //   4533c0               | mov                 ecx, dword ptr [esp + 0x50]
            //   488bd3               | dec                 eax
            //   c744242804000000     | lea                 eax, [esp + 0x58]
            //   4889442420           | inc                 ecx
            //   ff15????????         |                     
            //   488b4c2450           | mov                 ecx, 4
            //   ff15????????         |                     

        $sequence_6 = { 85c0 0f85e7000000 488b4c2460 488d442458 }
            // n = 4, score = 300
            //   85c0                 | mov                 ecx, dword ptr [esp + 0x50]
            //   0f85e7000000         | dec                 eax
            //   488b4c2460           | lea                 eax, [esp + 0x58]
            //   488d442458           | inc                 ecx

        $sequence_7 = { 488d542470 41b93f000f00 4533c0 48c7c102000080 }
            // n = 4, score = 300
            //   488d542470           | mov                 ecx, dword ptr [esp + 0x50]
            //   41b93f000f00         | dec                 eax
            //   4533c0               | lea                 eax, [esp + 0x58]
            //   48c7c102000080       | dec                 eax

        $sequence_8 = { 85c0 7534 488b4c2450 488d442458 41b904000000 4533c0 }
            // n = 6, score = 300
            //   85c0                 | test                eax, eax
            //   7534                 | jne                 0x36
            //   488b4c2450           | dec                 eax
            //   488d442458           | mov                 ecx, dword ptr [esp + 0x50]
            //   41b904000000         | dec                 eax
            //   4533c0               | lea                 eax, [esp + 0x58]

        $sequence_9 = { 51 6a04 53 68???????? 52 895c2430 ffd5 }
            // n = 7, score = 200
            //   51                   | xor                 eax, esp
            //   6a04                 | dec                 eax
            //   53                   | mov                 dword ptr [esp + 0x280], eax
            //   68????????           |                     
            //   52                   | dec                 eax
            //   895c2430             | lea                 ecx, [esp + 0x72]
            //   ffd5                 | jne                 0x36

        $sequence_10 = { 68???????? 52 e8???????? 83c40c 8d84242c040000 55 50 }
            // n = 7, score = 200
            //   68????????           |                     
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d84242c040000       | lea                 eax, [esp + 0x42c]
            //   55                   | push                ebp
            //   50                   | push                eax

        $sequence_11 = { c644342064 e9???????? c644342070 e9???????? c644342073 e9???????? }
            // n = 6, score = 200
            //   c644342064           | mov                 byte ptr [esp + esi + 0x20], 0x64
            //   e9????????           |                     
            //   c644342070           | mov                 byte ptr [esp + esi + 0x20], 0x70
            //   e9????????           |                     
            //   c644342073           | mov                 byte ptr [esp + esi + 0x20], 0x73
            //   e9????????           |                     

        $sequence_12 = { 51 56 66899c2440010000 66899c2446010000 66c784244a0100000700 }
            // n = 5, score = 200
            //   51                   | mov                 edx, ebx
            //   56                   | test                eax, eax
            //   66899c2440010000     | jne                 0xed
            //   66899c2446010000     | dec                 eax
            //   66c784244a0100000700     | mov    ecx, dword ptr [esp + 0x60]

        $sequence_13 = { e9???????? c644340c79 e9???????? c644340c77 e9???????? c644340c76 }
            // n = 6, score = 200
            //   e9????????           |                     
            //   c644340c79           | mov                 byte ptr [esp + esi + 0xc], 0x79
            //   e9????????           |                     
            //   c644340c77           | mov                 byte ptr [esp + esi + 0xc], 0x77
            //   e9????????           |                     
            //   c644340c76           | mov                 byte ptr [esp + esi + 0xc], 0x76

        $sequence_14 = { 8d442424 8d5001 8a08 83c001 }
            // n = 4, score = 200
            //   8d442424             | dec                 eax
            //   8d5001               | mov                 edx, ebx
            //   8a08                 | mov                 dword ptr [esp + 0x28], 4
            //   83c001               | dec                 eax

        $sequence_15 = { 66899c2440010000 66899c2446010000 66899c244a010000 66899c244c010000 }
            // n = 4, score = 200
            //   66899c2440010000     | mov                 dword ptr [esp + 0x20], eax
            //   66899c2446010000     | dec                 eax
            //   66899c244a010000     | mov                 ecx, dword ptr [esp + 0x50]
            //   66899c244c010000     | dec                 eax

        $sequence_16 = { 68???????? 52 e8???????? 83c408 8d442414 50 }
            // n = 6, score = 200
            //   68????????           |                     
            //   52                   | dec                 eax
            //   e8????????           |                     
            //   83c408               | mov                 ecx, dword ptr [esp + 0x50]
            //   8d442414             | dec                 eax
            //   50                   | lea                 eax, [esp + 0x58]

        $sequence_17 = { 83c408 8d442410 50 681f000200 53 8d4c2430 }
            // n = 6, score = 200
            //   83c408               | dec                 eax
            //   8d442410             | lea                 eax, [esp + 0x58]
            //   50                   | inc                 ebp
            //   681f000200           | xor                 ecx, ecx
            //   53                   | dec                 eax
            //   8d4c2430             | mov                 dword ptr [esp + 0x40], edi

        $sequence_18 = { 6a00 50 c684241401000000 e8???????? 0fbe4c2410 56 }
            // n = 6, score = 200
            //   6a00                 | inc                 ecx
            //   50                   | mov                 ecx, 4
            //   c684241401000000     | inc                 ebp
            //   e8????????           |                     
            //   0fbe4c2410           | xor                 eax, eax
            //   56                   | dec                 eax

        $sequence_19 = { c684342406000040 eb62 c68434240600007b eb58 }
            // n = 4, score = 200
            //   c684342406000040     | mov                 byte ptr [esp + esi + 0x624], 0x40
            //   eb62                 | jmp                 0x64
            //   c68434240600007b     | mov                 byte ptr [esp + esi + 0x624], 0x7b
            //   eb58                 | jmp                 0x5a

        $sequence_20 = { 8dbc24490c0000 899424400c0000 be???????? f3ab 66ab }
            // n = 5, score = 200
            //   8dbc24490c0000       | lea                 edi, [esp + 0xc49]
            //   899424400c0000       | mov                 dword ptr [esp + 0xc40], edx
            //   be????????           |                     
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax

        $sequence_21 = { eb3d c6440c0c3c eb36 c6440c0c28 eb2f c6440c0c24 eb28 }
            // n = 7, score = 200
            //   eb3d                 | jmp                 0x3f
            //   c6440c0c3c           | mov                 byte ptr [esp + ecx + 0xc], 0x3c
            //   eb36                 | jmp                 0x38
            //   c6440c0c28           | mov                 byte ptr [esp + ecx + 0xc], 0x28
            //   eb2f                 | jmp                 0x31
            //   c6440c0c24           | mov                 byte ptr [esp + ecx + 0xc], 0x24
            //   eb28                 | jmp                 0x2a

        $sequence_22 = { 8d442414 6a04 50 6a04 55 68???????? 51 }
            // n = 7, score = 200
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   6a04                 | push                4
            //   50                   | push                eax
            //   6a04                 | push                4
            //   55                   | push                ebp
            //   68????????           |                     
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 278528
}