rule win_green_dispenser_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.green_dispenser."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.green_dispenser"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c404 897508 895dfc 85f6 7453 8b450c 895e08 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   897508               | mov                 dword ptr [ebp + 8], esi
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   85f6                 | test                esi, esi
            //   7453                 | je                  0x55
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   895e08               | mov                 dword ptr [esi + 8], ebx

        $sequence_1 = { 8d3c9e 03c2 03fa 49 }
            // n = 4, score = 100
            //   8d3c9e               | lea                 edi, [esi + ebx*4]
            //   03c2                 | add                 eax, edx
            //   03fa                 | add                 edi, edx
            //   49                   | dec                 ecx

        $sequence_2 = { ffb554fbffff e8???????? 83c404 ff75d0 ff15???????? 8bbd9cfbffff 8b8da0fbffff }
            // n = 7, score = 100
            //   ffb554fbffff         | push                dword ptr [ebp - 0x4ac]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   ff75d0               | push                dword ptr [ebp - 0x30]
            //   ff15????????         |                     
            //   8bbd9cfbffff         | mov                 edi, dword ptr [ebp - 0x464]
            //   8b8da0fbffff         | mov                 ecx, dword ptr [ebp - 0x460]

        $sequence_3 = { 8b7d08 85ff 747e 391f 757a 6a18 e8???????? }
            // n = 7, score = 100
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   85ff                 | test                edi, edi
            //   747e                 | je                  0x80
            //   391f                 | cmp                 dword ptr [edi], ebx
            //   757a                 | jne                 0x7c
            //   6a18                 | push                0x18
            //   e8????????           |                     

        $sequence_4 = { c1f803 b9???????? 8d3c9530df4200 8b11 2b17 3bd0 }
            // n = 6, score = 100
            //   c1f803               | sar                 eax, 3
            //   b9????????           |                     
            //   8d3c9530df4200       | lea                 edi, [edx*4 + 0x42df30]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   2b17                 | sub                 edx, dword ptr [edi]
            //   3bd0                 | cmp                 edx, eax

        $sequence_5 = { 50 8b8530e5ffff c645f40d 8b048550aa4500 ff3406 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   8b8530e5ffff         | mov                 eax, dword ptr [ebp - 0x1ad0]
            //   c645f40d             | mov                 byte ptr [ebp - 0xc], 0xd
            //   8b048550aa4500       | mov                 eax, dword ptr [eax*4 + 0x45aa50]
            //   ff3406               | push                dword ptr [esi + eax]

        $sequence_6 = { 0f841d010000 397e04 0f8e14010000 8b4e08 894dec 51 8bd7 }
            // n = 7, score = 100
            //   0f841d010000         | je                  0x123
            //   397e04               | cmp                 dword ptr [esi + 4], edi
            //   0f8e14010000         | jle                 0x11a
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   51                   | push                ecx
            //   8bd7                 | mov                 edx, edi

        $sequence_7 = { 6a00 68???????? ff75e8 0f57c0 660fd645f1 c745ec09000000 ff15???????? }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   68????????           |                     
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   0f57c0               | xorps               xmm0, xmm0
            //   660fd645f1           | movq                qword ptr [ebp - 0xf], xmm0
            //   c745ec09000000       | mov                 dword ptr [ebp - 0x14], 9
            //   ff15????????         |                     

        $sequence_8 = { 8bec 53 56 8b750c 57 8bfa 83fe03 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   57                   | push                edi
            //   8bfa                 | mov                 edi, edx
            //   83fe03               | cmp                 esi, 3

        $sequence_9 = { 7436 ba02000000 e8???????? 8945fc 85c0 74bf 8bd0 }
            // n = 7, score = 100
            //   7436                 | je                  0x38
            //   ba02000000           | mov                 edx, 2
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   85c0                 | test                eax, eax
            //   74bf                 | je                  0xffffffc1
            //   8bd0                 | mov                 edx, eax

    condition:
        7 of them and filesize < 838656
}