rule win_greenshaitan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.greenshaitan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.greenshaitan"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d442434 64a300000000 8b6c2444 33db 895c2410 c744242c0f000000 895c2428 }
            // n = 7, score = 100
            //   8d442434             | lea                 eax, [esp + 0x34]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8b6c2444             | mov                 ebp, dword ptr [esp + 0x44]
            //   33db                 | xor                 ebx, ebx
            //   895c2410             | mov                 dword ptr [esp + 0x10], ebx
            //   c744242c0f000000     | mov                 dword ptr [esp + 0x2c], 0xf
            //   895c2428             | mov                 dword ptr [esp + 0x28], ebx

        $sequence_1 = { 6a02 68???????? 8d842494000000 e8???????? }
            // n = 4, score = 100
            //   6a02                 | push                2
            //   68????????           |                     
            //   8d842494000000       | lea                 eax, [esp + 0x94]
            //   e8????????           |                     

        $sequence_2 = { 895c244c 668944243c 3974246c 720d 8b4c2458 51 e8???????? }
            // n = 7, score = 100
            //   895c244c             | mov                 dword ptr [esp + 0x4c], ebx
            //   668944243c           | mov                 word ptr [esp + 0x3c], ax
            //   3974246c             | cmp                 dword ptr [esp + 0x6c], esi
            //   720d                 | jb                  0xf
            //   8b4c2458             | mov                 ecx, dword ptr [esp + 0x58]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_3 = { 7594 8b7c2414 83ff01 7534 }
            // n = 4, score = 100
            //   7594                 | jne                 0xffffff96
            //   8b7c2414             | mov                 edi, dword ptr [esp + 0x14]
            //   83ff01               | cmp                 edi, 1
            //   7534                 | jne                 0x36

        $sequence_4 = { ff15???????? 8d442404 c746180f000000 c7461400000000 c6460400 8d5001 8a08 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8d442404             | lea                 eax, [esp + 4]
            //   c746180f000000       | mov                 dword ptr [esi + 0x18], 0xf
            //   c7461400000000       | mov                 dword ptr [esi + 0x14], 0
            //   c6460400             | mov                 byte ptr [esi + 4], 0
            //   8d5001               | lea                 edx, [eax + 1]
            //   8a08                 | mov                 cl, byte ptr [eax]

        $sequence_5 = { 3974246c 720d 8b4c2458 51 e8???????? 83c404 8b542430 }
            // n = 7, score = 100
            //   3974246c             | cmp                 dword ptr [esp + 0x6c], esi
            //   720d                 | jb                  0xf
            //   8b4c2458             | mov                 ecx, dword ptr [esp + 0x58]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b542430             | mov                 edx, dword ptr [esp + 0x30]

        $sequence_6 = { 56 e8???????? 56 8bd8 e8???????? 8be8 8b4734 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   56                   | push                esi
            //   8bd8                 | mov                 ebx, eax
            //   e8????????           |                     
            //   8be8                 | mov                 ebp, eax
            //   8b4734               | mov                 eax, dword ptr [edi + 0x34]

        $sequence_7 = { c74424480f000000 895c2444 885c2434 eb1b 837d6810 7205 8b4554 }
            // n = 7, score = 100
            //   c74424480f000000     | mov                 dword ptr [esp + 0x48], 0xf
            //   895c2444             | mov                 dword ptr [esp + 0x44], ebx
            //   885c2434             | mov                 byte ptr [esp + 0x34], bl
            //   eb1b                 | jmp                 0x1d
            //   837d6810             | cmp                 dword ptr [ebp + 0x68], 0x10
            //   7205                 | jb                  7
            //   8b4554               | mov                 eax, dword ptr [ebp + 0x54]

        $sequence_8 = { 53 890a e8???????? 55 e8???????? 83c408 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   890a                 | mov                 dword ptr [edx], ecx
            //   e8????????           |                     
            //   55                   | push                ebp
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_9 = { 8bf1 8b4814 c744240800000000 7214 8b4004 51 8bd8 }
            // n = 7, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   8b4814               | mov                 ecx, dword ptr [eax + 0x14]
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   7214                 | jb                  0x16
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   51                   | push                ecx
            //   8bd8                 | mov                 ebx, eax

    condition:
        7 of them and filesize < 253952
}