rule win_greetingghoul_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.greetingghoul."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.greetingghoul"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945f4 33c9 894df8 380f 7409 }
            // n = 5, score = 200
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   33c9                 | xor                 ecx, ecx
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   380f                 | cmp                 byte ptr [edi], cl
            //   7409                 | je                  0xb

        $sequence_1 = { 57 660fd603 33ff c6430800 c70600000000 }
            // n = 5, score = 200
            //   57                   | push                edi
            //   660fd603             | movq                qword ptr [ebx], xmm0
            //   33ff                 | xor                 edi, edi
            //   c6430800             | mov                 byte ptr [ebx + 8], 0
            //   c70600000000         | mov                 dword ptr [esi], 0

        $sequence_2 = { ff15???????? 85c0 7e06 03f0 2bf8 75ea }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7e06                 | jle                 8
            //   03f0                 | add                 esi, eax
            //   2bf8                 | sub                 edi, eax
            //   75ea                 | jne                 0xffffffec

        $sequence_3 = { 750c 6a21 e8???????? 83c404 eb0d 8d4721 }
            // n = 6, score = 200
            //   750c                 | jne                 0xe
            //   6a21                 | push                0x21
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   eb0d                 | jmp                 0xf
            //   8d4721               | lea                 eax, [edi + 0x21]

        $sequence_4 = { c3 0fbec8 0fbec3 8b5dfc 2bc8 74e1 }
            // n = 6, score = 200
            //   c3                   | ret                 
            //   0fbec8               | movsx               ecx, al
            //   0fbec3               | movsx               eax, bl
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]
            //   2bc8                 | sub                 ecx, eax
            //   74e1                 | je                  0xffffffe3

        $sequence_5 = { 75eb 8b5dfc 83c8ff 3b5df8 5f 0f44d8 5e }
            // n = 7, score = 200
            //   75eb                 | jne                 0xffffffed
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]
            //   83c8ff               | or                  eax, 0xffffffff
            //   3b5df8               | cmp                 ebx, dword ptr [ebp - 8]
            //   5f                   | pop                 edi
            //   0f44d8               | cmove               ebx, eax
            //   5e                   | pop                 esi

        $sequence_6 = { 7e06 03d8 2bf0 75ea }
            // n = 4, score = 200
            //   7e06                 | jle                 8
            //   03d8                 | add                 ebx, eax
            //   2bf0                 | sub                 esi, eax
            //   75ea                 | jne                 0xffffffec

        $sequence_7 = { 33f6 8a17 80fa20 740a }
            // n = 4, score = 200
            //   33f6                 | xor                 esi, esi
            //   8a17                 | mov                 dl, byte ptr [edi]
            //   80fa20               | cmp                 dl, 0x20
            //   740a                 | je                  0xc

        $sequence_8 = { e8???????? 83c404 eb10 8d4701 03c3 50 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   eb10                 | jmp                 0x12
            //   8d4701               | lea                 eax, [edi + 1]
            //   03c3                 | add                 eax, ebx
            //   50                   | push                eax

        $sequence_9 = { 5d c3 5f c7462800000000 8bc3 5e 5b }
            // n = 7, score = 200
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   5f                   | pop                 edi
            //   c7462800000000       | mov                 dword ptr [esi + 0x28], 0
            //   8bc3                 | mov                 eax, ebx
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

    condition:
        7 of them and filesize < 696320
}