rule win_grillmark_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.grillmark."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grillmark"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8d4df4 56 51 53 50 57 }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   8d4df4               | lea                 ecx, [ebp - 0xc]
            //   56                   | push                esi
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_1 = { 6800000080 ff7510 ff15???????? 8bf8 83ffff 7436 53 }
            // n = 7, score = 300
            //   6800000080           | push                0x80000000
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   83ffff               | cmp                 edi, -1
            //   7436                 | je                  0x38
            //   53                   | push                ebx

        $sequence_2 = { f3ab 66ab aa 8d458c 895df8 50 895df4 }
            // n = 7, score = 300
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8d458c               | lea                 eax, [ebp - 0x74]
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   50                   | push                eax
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx

        $sequence_3 = { 83ffff 7504 33c0 eb1a }
            // n = 4, score = 300
            //   83ffff               | cmp                 edi, -1
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax
            //   eb1a                 | jmp                 0x1c

        $sequence_4 = { 66a5 a4 5f 33c0 3905???????? 5e 50 }
            // n = 7, score = 300
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   5f                   | pop                 edi
            //   33c0                 | xor                 eax, eax
            //   3905????????         |                     
            //   5e                   | pop                 esi
            //   50                   | push                eax

        $sequence_5 = { 57 e8???????? 8d85f4fcffff 50 57 }
            // n = 5, score = 300
            //   57                   | push                edi
            //   e8????????           |                     
            //   8d85f4fcffff         | lea                 eax, [ebp - 0x30c]
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_6 = { ff15???????? 6a40 33c0 59 8dbdfdfeffff 889dfcfeffff 53 }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   6a40                 | push                0x40
            //   33c0                 | xor                 eax, eax
            //   59                   | pop                 ecx
            //   8dbdfdfeffff         | lea                 edi, [ebp - 0x103]
            //   889dfcfeffff         | mov                 byte ptr [ebp - 0x104], bl
            //   53                   | push                ebx

        $sequence_7 = { 66ab aa 8d85fcfeffff 50 6804010000 e8???????? }
            // n = 6, score = 300
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   50                   | push                eax
            //   6804010000           | push                0x104
            //   e8????????           |                     

        $sequence_8 = { 50 57 ffb604010000 56 e8???????? 83c410 85c0 }
            // n = 7, score = 300
            //   50                   | push                eax
            //   57                   | push                edi
            //   ffb604010000         | push                dword ptr [esi + 0x104]
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax

        $sequence_9 = { 6a01 ff7508 e8???????? 56 e8???????? ff75f4 }
            // n = 6, score = 300
            //   6a01                 | push                1
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   ff75f4               | push                dword ptr [ebp - 0xc]

    condition:
        7 of them and filesize < 212992
}