rule win_grimagent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.grimagent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grimagent"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83ec18 c745f400000000 c745f800000000 c745e800000000 8b4508 8945f0 }
            // n = 6, score = 100
            //   83ec18               | sub                 esp, 0x18
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_1 = { 8b4d0c 51 e8???????? 83c404 3945f8 7328 8b55ec }
            // n = 7, score = 100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   3945f8               | cmp                 dword ptr [ebp - 8], eax
            //   7328                 | jae                 0x2a
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]

        $sequence_2 = { 85c0 7420 8b4d08 51 8d95f4feffff 52 e8???????? }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7420                 | je                  0x22
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   8d95f4feffff         | lea                 edx, [ebp - 0x10c]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_3 = { 83c404 3945f8 750e c745e801000000 b801000000 eb1a 8b4df0 }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   3945f8               | cmp                 dword ptr [ebp - 8], eax
            //   750e                 | jne                 0x10
            //   c745e801000000       | mov                 dword ptr [ebp - 0x18], 1
            //   b801000000           | mov                 eax, 1
            //   eb1a                 | jmp                 0x1c
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]

        $sequence_4 = { 0f8394000000 8b4df0 0fb711 8b45fc }
            // n = 4, score = 100
            //   0f8394000000         | jae                 0x9a
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   0fb711               | movzx               edx, word ptr [ecx]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_5 = { 8b45ec 83c002 8945ec 8b4dfc 83c102 894dfc eb02 }
            // n = 7, score = 100
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   83c002               | add                 eax, 2
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   83c102               | add                 ecx, 2
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   eb02                 | jmp                 4

        $sequence_6 = { 85c0 7420 8b4d08 51 8d95f4feffff }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   7420                 | je                  0x22
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   8d95f4feffff         | lea                 edx, [ebp - 0x10c]

        $sequence_7 = { 83c404 3945f8 750e c745e801000000 }
            // n = 4, score = 100
            //   83c404               | add                 esp, 4
            //   3945f8               | cmp                 dword ptr [ebp - 8], eax
            //   750e                 | jne                 0x10
            //   c745e801000000       | mov                 dword ptr [ebp - 0x18], 1

        $sequence_8 = { 8b4508 0fbe08 85c9 7426 }
            // n = 4, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0fbe08               | movsx               ecx, byte ptr [eax]
            //   85c9                 | test                ecx, ecx
            //   7426                 | je                  0x28

        $sequence_9 = { 8b4508 8945f0 8b4d0c 894dfc c745f400000000 eb09 8b55f4 }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   eb09                 | jmp                 0xb
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

    condition:
        7 of them and filesize < 582656
}