rule win_grok_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.grok."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grok"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3945f4 7308 8b4df4 c60100 ebe4 8b55f8 c7420900000000 }
            // n = 7, score = 400
            //   3945f4               | cmp                 dword ptr [ebp - 0xc], eax
            //   7308                 | jae                 0xa
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   c60100               | mov                 byte ptr [ecx], 0
            //   ebe4                 | jmp                 0xffffffe6
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   c7420900000000       | mov                 dword ptr [edx + 9], 0

        $sequence_1 = { 8b8de0fdffff 8a11 8895dffdffff 8b85e4fdffff 3a10 7546 }
            // n = 6, score = 400
            //   8b8de0fdffff         | mov                 ecx, dword ptr [ebp - 0x220]
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   8895dffdffff         | mov                 byte ptr [ebp - 0x221], dl
            //   8b85e4fdffff         | mov                 eax, dword ptr [ebp - 0x21c]
            //   3a10                 | cmp                 dl, byte ptr [eax]
            //   7546                 | jne                 0x48

        $sequence_2 = { 837d1004 7307 b8060200c0 eb0e 8b4508 8b403c c70030120000 }
            // n = 7, score = 400
            //   837d1004             | cmp                 dword ptr [ebp + 0x10], 4
            //   7307                 | jae                 9
            //   b8060200c0           | mov                 eax, 0xc0000206
            //   eb0e                 | jmp                 0x10
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b403c               | mov                 eax, dword ptr [eax + 0x3c]
            //   c70030120000         | mov                 dword ptr [eax], 0x1230

        $sequence_3 = { 0f8ca4000000 53 ff15???????? 8b0d???????? 3b01 8b3d???????? }
            // n = 6, score = 400
            //   0f8ca4000000         | jl                  0xaa
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8b0d????????         |                     
            //   3b01                 | cmp                 eax, dword ptr [ecx]
            //   8b3d????????         |                     

        $sequence_4 = { 0f85a2000000 681c010000 8d85c8feffff 50 6a00 8b4d08 51 }
            // n = 7, score = 400
            //   0f85a2000000         | jne                 0xa8
            //   681c010000           | push                0x11c
            //   8d85c8feffff         | lea                 eax, [ebp - 0x138]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   51                   | push                ecx

        $sequence_5 = { 8975dc ff15???????? 85c0 8b1d???????? 7d11 be2a0000c0 ff75f8 }
            // n = 7, score = 400
            //   8975dc               | mov                 dword ptr [ebp - 0x24], esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   8b1d????????         |                     
            //   7d11                 | jge                 0x13
            //   be2a0000c0           | mov                 esi, 0xc000002a
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_6 = { a1???????? 83c40c c780bc01000001000000 33c0 5f 5e 5d }
            // n = 7, score = 400
            //   a1????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c780bc01000001000000     | mov    dword ptr [eax + 0x1bc], 1
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_7 = { b81a0000c0 eb5c 50 8d460a 56 50 e8???????? }
            // n = 7, score = 400
            //   b81a0000c0           | mov                 eax, 0xc000001a
            //   eb5c                 | jmp                 0x5e
            //   50                   | push                eax
            //   8d460a               | lea                 eax, [esi + 0xa]
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_8 = { b89a0000c0 eb51 8d45f8 50 ff75f8 56 6a01 }
            // n = 7, score = 400
            //   b89a0000c0           | mov                 eax, 0xc000009a
            //   eb51                 | jmp                 0x53
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   56                   | push                esi
            //   6a01                 | push                1

        $sequence_9 = { 85c0 0f842d010000 8b742410 8b3d???????? 6a00 6a10 6a01 }
            // n = 7, score = 400
            //   85c0                 | test                eax, eax
            //   0f842d010000         | je                  0x133
            //   8b742410             | mov                 esi, dword ptr [esp + 0x10]
            //   8b3d????????         |                     
            //   6a00                 | push                0
            //   6a10                 | push                0x10
            //   6a01                 | push                1

    condition:
        7 of them and filesize < 84992
}