rule win_ground_peony_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ground_peony."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ground_peony"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d15c28a0000 488d0db38a0000 e8???????? 488b4308 833800 }
            // n = 5, score = 100
            //   488d15c28a0000       | dec                 eax
            //   488d0db38a0000       | sub                 esp, 0x20
            //   e8????????           |                     
            //   488b4308             | xor                 ebx, ebx
            //   833800               | dec                 eax

        $sequence_1 = { 4833c4 4889842460050000 488bd1 4d8d4310 498d8bd8fbffff ff15???????? }
            // n = 6, score = 100
            //   4833c4               | lea                 eax, [0x9689]
            //   4889842460050000     | dec                 eax
            //   488bd1               | mov                 edi, ecx
            //   4d8d4310             | dec                 eax
            //   498d8bd8fbffff       | lea                 edx, [0x9687]
            //   ff15????????         |                     

        $sequence_2 = { eb10 488bc8 ff15???????? 488d0d251e0100 }
            // n = 4, score = 100
            //   eb10                 | dec                 esp
            //   488bc8               | lea                 ecx, [0xffffd4e7]
            //   ff15????????         |                     
            //   488d0d251e0100       | dec                 esp

        $sequence_3 = { e8???????? 48b8d2bc1a37d2bc1a37 41b802000000 4889842420080000 8bd5 4889842428080000 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   48b8d2bc1a37d2bc1a37     | mov    eax, dword ptr [esp + 0x38]
            //   41b802000000         | mov                 ecx, 3
            //   4889842420080000     | dec                 esp
            //   8bd5                 | lea                 eax, [0x7224]
            //   4889842428080000     | dec                 eax

        $sequence_4 = { ff15???????? 33d2 488d4c2450 41b804010000 e8???????? 41b804010000 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   33d2                 | xor                 edx, edx
            //   488d4c2450           | xor                 edx, edx
            //   41b804010000         | dec                 eax
            //   e8????????           |                     
            //   41b804010000         | lea                 ecx, [esp + 0x821]

        $sequence_5 = { f20f102d???????? f20f590d???????? f20f59ee f20f5ce9 f2410f1004c1 488d1536830000 }
            // n = 6, score = 100
            //   f20f102d????????     |                     
            //   f20f590d????????     |                     
            //   f20f59ee             | mov                 dword ptr [esp + 0x20], 4
            //   f20f5ce9             | dec                 eax
            //   f2410f1004c1         | add                 edx, eax
            //   488d1536830000       | dec                 eax

        $sequence_6 = { 4883c428 c3 488d15878e0000 488d0d808d0000 }
            // n = 4, score = 100
            //   4883c428             | inc                 esp
            //   c3                   | mov                 byte ptr [esp + 0x70], dh
            //   488d15878e0000       | jmp                 0x222
            //   488d0d808d0000       | dec                 eax

        $sequence_7 = { 8b0a e8???????? 90 488d1d9e2f0100 }
            // n = 4, score = 100
            //   8b0a                 | arpl                bx, ax
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   488d1d9e2f0100       | lea                 edx, [edx + eax*4]

        $sequence_8 = { e8???????? eb22 488d0da51a0100 e8???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   eb22                 | lea                 ecx, [0xd4bc]
            //   488d0da51a0100       | dec                 ecx
            //   e8????????           |                     

        $sequence_9 = { 4883ec20 488bda 4c8d0def960000 8bf9 }
            // n = 4, score = 100
            //   4883ec20             | test                esi, esi
            //   488bda               | jle                 0x7c
            //   4c8d0def960000       | lea                 eax, [ebp + 1]
            //   8bf9                 | and                 eax, 0x800000ff

    condition:
        7 of them and filesize < 217088
}