rule win_gsecdump_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gsecdump."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gsecdump"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 8b742408 85f6 57 8bf9 7505 bef7030000 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   8b742408             | mov                 esi, dword ptr [esp + 8]
            //   85f6                 | test                esi, esi
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   7505                 | jne                 7
            //   bef7030000           | mov                 esi, 0x3f7

        $sequence_1 = { e8???????? 6aff 53 8d4c2430 51 8bce e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   6aff                 | push                -1
            //   53                   | push                ebx
            //   8d4c2430             | lea                 ecx, [esp + 0x30]
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_2 = { 720d 8b542430 52 e8???????? 83c404 8bc6 8b4c2448 }
            // n = 7, score = 100
            //   720d                 | jb                  0xf
            //   8b542430             | mov                 edx, dword ptr [esp + 0x30]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8bc6                 | mov                 eax, esi
            //   8b4c2448             | mov                 ecx, dword ptr [esp + 0x48]

        $sequence_3 = { 8bef 83c701 eba4 8b4e24 3bca 740c }
            // n = 6, score = 100
            //   8bef                 | mov                 ebp, edi
            //   83c701               | add                 edi, 1
            //   eba4                 | jmp                 0xffffffa6
            //   8b4e24               | mov                 ecx, dword ptr [esi + 0x24]
            //   3bca                 | cmp                 ecx, edx
            //   740c                 | je                  0xe

        $sequence_4 = { 7422 8b4c2440 51 8b4c2428 8d542420 52 51 }
            // n = 7, score = 100
            //   7422                 | je                  0x24
            //   8b4c2440             | mov                 ecx, dword ptr [esp + 0x40]
            //   51                   | push                ecx
            //   8b4c2428             | mov                 ecx, dword ptr [esp + 0x28]
            //   8d542420             | lea                 edx, [esp + 0x20]
            //   52                   | push                edx
            //   51                   | push                ecx

        $sequence_5 = { 8db424c0000000 89742424 896c2428 8bc2 7307 8d8424c4000000 }
            // n = 6, score = 100
            //   8db424c0000000       | lea                 esi, [esp + 0xc0]
            //   89742424             | mov                 dword ptr [esp + 0x24], esi
            //   896c2428             | mov                 dword ptr [esp + 0x28], ebp
            //   8bc2                 | mov                 eax, edx
            //   7307                 | jae                 9
            //   8d8424c4000000       | lea                 eax, [esp + 0xc4]

        $sequence_6 = { 50 895c241c e8???????? 8b4c2464 8b542468 8b44246c 894e44 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   895c241c             | mov                 dword ptr [esp + 0x1c], ebx
            //   e8????????           |                     
            //   8b4c2464             | mov                 ecx, dword ptr [esp + 0x64]
            //   8b542468             | mov                 edx, dword ptr [esp + 0x68]
            //   8b44246c             | mov                 eax, dword ptr [esp + 0x6c]
            //   894e44               | mov                 dword ptr [esi + 0x44], ecx

        $sequence_7 = { 50 8b8de8f7ffff 8b5110 ffd2 81c49c000000 85c0 7d0c }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8b8de8f7ffff         | mov                 ecx, dword ptr [ebp - 0x818]
            //   8b5110               | mov                 edx, dword ptr [ecx + 0x10]
            //   ffd2                 | call                edx
            //   81c49c000000         | add                 esp, 0x9c
            //   85c0                 | test                eax, eax
            //   7d0c                 | jge                 0xe

        $sequence_8 = { e8???????? 33c0 e9???????? 6a06 68???????? 8d4dd4 c745ec0f000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   6a06                 | push                6
            //   68????????           |                     
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   c745ec0f000000       | mov                 dword ptr [ebp - 0x14], 0xf

        $sequence_9 = { 83f8ff 7409 8b74246c eb03 8d7004 56 8d4c2418 }
            // n = 7, score = 100
            //   83f8ff               | cmp                 eax, -1
            //   7409                 | je                  0xb
            //   8b74246c             | mov                 esi, dword ptr [esp + 0x6c]
            //   eb03                 | jmp                 5
            //   8d7004               | lea                 esi, [eax + 4]
            //   56                   | push                esi
            //   8d4c2418             | lea                 ecx, [esp + 0x18]

    condition:
        7 of them and filesize < 630784
}