rule win_gtpdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.gtpdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gtpdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb600 31d0 8801 8045fb01 8345fc01 }
            // n = 5, score = 200
            //   0fb600               | dec                 eax
            //   31d0                 | mov                 eax, dword ptr [ebp - 0x10]
            //   8801                 | dec                 eax
            //   8045fb01             | add                 eax, 5
            //   8345fc01             | dec                 eax

        $sequence_1 = { 0fb600 31d0 8801 8045fb01 }
            // n = 4, score = 200
            //   0fb600               | lea                 eax, [ebp - 0x20]
            //   31d0                 | movzx               eax, byte ptr [eax]
            //   8801                 | movzx               eax, al
            //   8045fb01             | add                 dword ptr [ebp - 4], eax

        $sequence_2 = { fc b932000000 b800000000 f3aa }
            // n = 4, score = 200
            //   fc                   | mov                 dword ptr [esp + 4], 0
            //   b932000000           | mov                 dword ptr [esp], edx
            //   b800000000           | mov                 eax, dword ptr [ebp - 0x18]
            //   f3aa                 | mov                 dword ptr [esp + 4], 0

        $sequence_3 = { 31d0 8801 8045fb01 8345fc01 }
            // n = 4, score = 200
            //   31d0                 | add                 edx, 0xc
            //   8801                 | movzx               ecx, ax
            //   8045fb01             | dec                 esp
            //   8345fc01             | lea                 ecx, [ebp - 0xe30]

        $sequence_4 = { 4989c0 be04000000 e8???????? 0fb785acf9ffff 83c020 }
            // n = 5, score = 100
            //   4989c0               | movzx               eax, word ptr [eax + 2]
            //   be04000000           | movzx               edi, ax
            //   e8????????           |                     
            //   0fb785acf9ffff       | dec                 eax
            //   83c020               | add                 eax, edx

        $sequence_5 = { 8b45cc 66895002 c7042400000000 e8???????? }
            // n = 4, score = 100
            //   8b45cc               | mov                 word ptr [eax + 1], 2
            //   66895002             | cmp                 word ptr [ebp - 0x624], 0x4af
            //   c7042400000000       | mov                 dword ptr [ebp - 0x10], eax
            //   e8????????           |                     

        $sequence_6 = { 48833d????????00 4889e5 7416 b800000000 4885c0 740c bf???????? }
            // n = 7, score = 100
            //   48833d????????00     |                     
            //   4889e5               | lea                 eax, [ebp - 0xe78]
            //   7416                 | mov                 dword ptr [esp], eax
            //   b800000000           | cld                 
            //   4885c0               | mov                 ecx, edx
            //   740c                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   bf????????           |                     

        $sequence_7 = { 83e801 03450c 66c7000a20 c6400200 8b450c }
            // n = 5, score = 100
            //   83e801               | mov                 edi, dword ptr [ebp - 0x10]
            //   03450c               | mov                 eax, 0
            //   66c7000a20           | movzx               eax, word ptr [ebp - 4]
            //   c6400200             | mov                 dword ptr [ebp - 0x24], eax
            //   8b450c               | dec                 eax

        $sequence_8 = { 4929c4 49c1fc03 4d85e4 741e 31ed }
            // n = 5, score = 100
            //   4929c4               | leave               
            //   49c1fc03             | dec                 eax
            //   4d85e4               | add                 eax, edx
            //   741e                 | dec                 eax
            //   31ed                 | mov                 dword ptr [ebp - 0x28], eax

        $sequence_9 = { c9 c3 55 89e5 83ec18 8b450c 8b5514 }
            // n = 7, score = 100
            //   c9                   | mov                 eax, dword ptr [ebp - 0x20]
            //   c3                   | movzx               eax, word ptr [eax + 2]
            //   55                   | mov                 eax, dword ptr [ebp - 0x24]
            //   89e5                 | mov                 edx, eax
            //   83ec18               | lea                 eax, [ebp - 0x830]
            //   8b450c               | add                 eax, edx
            //   8b5514               | mov                 dword ptr [ebp - 0x1c], eax

    condition:
        7 of them and filesize < 4210688
}