rule win_hacksfase_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hacksfase."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hacksfase"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8965e8 33db 895de0 895de4 895dd8 895ddc 895dfc }
            // n = 7, score = 100
            //   8965e8               | mov                 dword ptr [ebp - 0x18], esp
            //   33db                 | xor                 ebx, ebx
            //   895de0               | mov                 dword ptr [ebp - 0x20], ebx
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx
            //   895dd8               | mov                 dword ptr [ebp - 0x28], ebx
            //   895ddc               | mov                 dword ptr [ebp - 0x24], ebx
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx

        $sequence_1 = { 56 6a02 68???????? 56 ff500c }
            // n = 5, score = 100
            //   56                   | push                esi
            //   6a02                 | push                2
            //   68????????           |                     
            //   56                   | push                esi
            //   ff500c               | call                dword ptr [eax + 0xc]

        $sequence_2 = { 56 ffd3 50 ffd5 56 ff15???????? }
            // n = 6, score = 100
            //   56                   | push                esi
            //   ffd3                 | call                ebx
            //   50                   | push                eax
            //   ffd5                 | call                ebp
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_3 = { 89442418 894c241c 6a00 6a00 6a00 6a06 6a01 }
            // n = 7, score = 100
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   894c241c             | mov                 dword ptr [esp + 0x1c], ecx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a06                 | push                6
            //   6a01                 | push                1

        $sequence_4 = { 3975b4 7416 3975bc 7411 ff75b4 8bcb }
            // n = 6, score = 100
            //   3975b4               | cmp                 dword ptr [ebp - 0x4c], esi
            //   7416                 | je                  0x18
            //   3975bc               | cmp                 dword ptr [ebp - 0x44], esi
            //   7411                 | je                  0x13
            //   ff75b4               | push                dword ptr [ebp - 0x4c]
            //   8bcb                 | mov                 ecx, ebx

        $sequence_5 = { 7479 bf02000000 8b442414 40 3bc7 89442414 }
            // n = 6, score = 100
            //   7479                 | je                  0x7b
            //   bf02000000           | mov                 edi, 2
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   40                   | inc                 eax
            //   3bc7                 | cmp                 eax, edi
            //   89442414             | mov                 dword ptr [esp + 0x14], eax

        $sequence_6 = { e8???????? 8b1d???????? 83c40c 68e8030000 ffd3 6a00 6a00 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b1d????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   68e8030000           | push                0x3e8
            //   ffd3                 | call                ebx
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_7 = { 895dc8 895dd0 ff5064 3bc3 894508 7d5d }
            // n = 6, score = 100
            //   895dc8               | mov                 dword ptr [ebp - 0x38], ebx
            //   895dd0               | mov                 dword ptr [ebp - 0x30], ebx
            //   ff5064               | call                dword ptr [eax + 0x64]
            //   3bc3                 | cmp                 eax, ebx
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   7d5d                 | jge                 0x5f

        $sequence_8 = { b8???????? e8???????? 83ec0c 8b412c 56 57 }
            // n = 6, score = 100
            //   b8????????           |                     
            //   e8????????           |                     
            //   83ec0c               | sub                 esp, 0xc
            //   8b412c               | mov                 eax, dword ptr [ecx + 0x2c]
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_9 = { 33d2 8d0cb6 f7f6 8d0c89 }
            // n = 4, score = 100
            //   33d2                 | xor                 edx, edx
            //   8d0cb6               | lea                 ecx, [esi + esi*4]
            //   f7f6                 | div                 esi
            //   8d0c89               | lea                 ecx, [ecx + ecx*4]

    condition:
        7 of them and filesize < 106496
}