rule win_hamweq_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hamweq."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hamweq"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff500c 56 e8???????? 8b06 }
            // n = 4, score = 200
            //   ff500c               | call                dword ptr [eax + 0xc]
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_1 = { 8d8500feffff 50 ff5148 8b4e08 8b06 ff7138 }
            // n = 6, score = 200
            //   8d8500feffff         | lea                 eax, [ebp - 0x200]
            //   50                   | push                eax
            //   ff5148               | call                dword ptr [ecx + 0x48]
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   ff7138               | push                dword ptr [ecx + 0x38]

        $sequence_2 = { ff5744 50 8d8500feffff 50 }
            // n = 4, score = 200
            //   ff5744               | call                dword ptr [edi + 0x44]
            //   50                   | push                eax
            //   8d8500feffff         | lea                 eax, [ebp - 0x200]
            //   50                   | push                eax

        $sequence_3 = { 51 ff5038 b906030000 33c0 80bdfcfdffff5c }
            // n = 5, score = 200
            //   51                   | push                ecx
            //   ff5038               | call                dword ptr [eax + 0x38]
            //   b906030000           | mov                 ecx, 0x306
            //   33c0                 | xor                 eax, eax
            //   80bdfcfdffff5c       | cmp                 byte ptr [ebp - 0x204], 0x5c

        $sequence_4 = { 0f847a030000 85c0 0f8472030000 ff35???????? ff75f8 ffd6 }
            // n = 6, score = 200
            //   0f847a030000         | je                  0x380
            //   85c0                 | test                eax, eax
            //   0f8472030000         | je                  0x378
            //   ff35????????         |                     
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ffd6                 | call                esi

        $sequence_5 = { 50 8d45e0 50 ff750c 56 e8???????? 83c410 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

        $sequence_6 = { ff7508 ff5020 8b4e08 8b06 ffb180010000 8d8decfeffff 51 }
            // n = 7, score = 200
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff5020               | call                dword ptr [eax + 0x20]
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   ffb180010000         | push                dword ptr [ecx + 0x180]
            //   8d8decfeffff         | lea                 ecx, [ebp - 0x114]
            //   51                   | push                ecx

        $sequence_7 = { 8b0e ff30 33db ff5144 }
            // n = 4, score = 200
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   ff30                 | push                dword ptr [eax]
            //   33db                 | xor                 ebx, ebx
            //   ff5144               | call                dword ptr [ecx + 0x44]

        $sequence_8 = { 3ad0 742d 8b4c2414 8bd6 2bd1 8a19 3ad8 }
            // n = 7, score = 200
            //   3ad0                 | cmp                 dl, al
            //   742d                 | je                  0x2f
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   8bd6                 | mov                 edx, esi
            //   2bd1                 | sub                 edx, ecx
            //   8a19                 | mov                 bl, byte ptr [ecx]
            //   3ad8                 | cmp                 bl, al

        $sequence_9 = { 33c0 8dbdfcfdffff f3ab 8b4e08 8b06 ffb1e8000000 8d8dfcfdffff }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   8dbdfcfdffff         | lea                 edi, [ebp - 0x204]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   ffb1e8000000         | push                dword ptr [ecx + 0xe8]
            //   8d8dfcfdffff         | lea                 ecx, [ebp - 0x204]

    condition:
        7 of them and filesize < 24576
}