rule win_hancitor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hancitor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hancitor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 6a00 6824040000 6a00 6a00 }
            // n = 5, score = 1000
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6824040000           | push                0x424
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_1 = { 6800010000 6a40 68???????? e8???????? }
            // n = 4, score = 900
            //   6800010000           | push                0x100
            //   6a40                 | push                0x40
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_2 = { 750d e8???????? 83c010 a3???????? }
            // n = 4, score = 800
            //   750d                 | jne                 0xf
            //   e8????????           |                     
            //   83c010               | add                 eax, 0x10
            //   a3????????           |                     

        $sequence_3 = { 6a20 68???????? 68???????? e8???????? 83c410 }
            // n = 5, score = 700
            //   6a20                 | push                0x20
            //   68????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

        $sequence_4 = { 55 8bec 81ec58010000 6a44 }
            // n = 4, score = 700
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec58010000         | sub                 esp, 0x158
            //   6a44                 | push                0x44

        $sequence_5 = { c745f800000000 c745fc00000000 c745e800000000 6a40 6800300000 8b45f0 50 }
            // n = 7, score = 600
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   6a40                 | push                0x40
            //   6800300000           | push                0x3000
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   50                   | push                eax

        $sequence_6 = { 57 8b483c 33f6 03c8 6a40 }
            // n = 5, score = 600
            //   57                   | push                edi
            //   8b483c               | mov                 ecx, dword ptr [eax + 0x3c]
            //   33f6                 | xor                 esi, esi
            //   03c8                 | add                 ecx, eax
            //   6a40                 | push                0x40

        $sequence_7 = { 50 c60600 ff15???????? 8b3d???????? }
            // n = 4, score = 600
            //   50                   | push                eax
            //   c60600               | mov                 byte ptr [esi], 0
            //   ff15????????         |                     
            //   8b3d????????         |                     

        $sequence_8 = { 8b01 2b4234 03450c 8b4de0 8901 8b55f8 83c202 }
            // n = 7, score = 600
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   2b4234               | sub                 eax, dword ptr [edx + 0x34]
            //   03450c               | add                 eax, dword ptr [ebp + 0xc]
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   83c202               | add                 edx, 2

        $sequence_9 = { 8b4dec 8b5150 8955f0 c745f800000000 }
            // n = 4, score = 600
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   8b5150               | mov                 edx, dword ptr [ecx + 0x50]
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0

        $sequence_10 = { 8bec 8b4d08 6a00 6a01 }
            // n = 4, score = 600
            //   8bec                 | mov                 ebp, esp
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   6a00                 | push                0
            //   6a01                 | push                1

        $sequence_11 = { 8b4508 0fbe08 83f97b 750b 8b5508 83c201 895508 }
            // n = 7, score = 600
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0fbe08               | movsx               ecx, byte ptr [eax]
            //   83f97b               | cmp                 ecx, 0x7b
            //   750b                 | jne                 0xd
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   83c201               | add                 edx, 1
            //   895508               | mov                 dword ptr [ebp + 8], edx

        $sequence_12 = { 8955dc 8b45dc 8b08 894dd8 8b5508 }
            // n = 5, score = 600
            //   8955dc               | mov                 dword ptr [ebp - 0x24], edx
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   894dd8               | mov                 dword ptr [ebp - 0x28], ecx
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_13 = { 83f941 72ed 881d???????? c705????????01000000 }
            // n = 4, score = 600
            //   83f941               | cmp                 ecx, 0x41
            //   72ed                 | jb                  0xffffffef
            //   881d????????         |                     
            //   c705????????01000000     |     

        $sequence_14 = { 8b4c1010 51 6b55fc28 8b45f4 8b4d08 034c1014 51 }
            // n = 7, score = 600
            //   8b4c1010             | mov                 ecx, dword ptr [eax + edx + 0x10]
            //   51                   | push                ecx
            //   6b55fc28             | imul                edx, dword ptr [ebp - 4], 0x28
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   034c1014             | add                 ecx, dword ptr [eax + edx + 0x14]
            //   51                   | push                ecx

        $sequence_15 = { c745fc00000000 b901000000 85c9 7448 8b5508 }
            // n = 5, score = 600
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   b901000000           | mov                 ecx, 1
            //   85c9                 | test                ecx, ecx
            //   7448                 | je                  0x4a
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_16 = { 41 3bc8 72f7 c6043000 40 }
            // n = 5, score = 600
            //   41                   | inc                 ecx
            //   3bc8                 | cmp                 ecx, eax
            //   72f7                 | jb                  0xfffffff9
            //   c6043000             | mov                 byte ptr [eax + esi], 0
            //   40                   | inc                 eax

        $sequence_17 = { 6a01 51 8b413c 8b440828 03c1 }
            // n = 5, score = 600
            //   6a01                 | push                1
            //   51                   | push                ecx
            //   8b413c               | mov                 eax, dword ptr [ecx + 0x3c]
            //   8b440828             | mov                 eax, dword ptr [eax + ecx + 0x28]
            //   03c1                 | add                 eax, ecx

        $sequence_18 = { 83c410 83f801 750e 57 ff15???????? 8bd8 }
            // n = 6, score = 600
            //   83c410               | add                 esp, 0x10
            //   83f801               | cmp                 eax, 1
            //   750e                 | jne                 0x10
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_19 = { f9 a6 c3 4b fd 008d4556f400 08640f08 }
            // n = 7, score = 100
            //   f9                   | stc                 
            //   a6                   | cmpsb               byte ptr [esi], byte ptr es:[edi]
            //   c3                   | ret                 
            //   4b                   | dec                 ebx
            //   fd                   | std                 
            //   008d4556f400         | add                 byte ptr [ebp + 0xf45645], cl
            //   08640f08             | or                  byte ptr [edi + ecx + 8], ah

        $sequence_20 = { 40 8945d0 8b45c0 83c008 8945c0 8b45b8 }
            // n = 6, score = 100
            //   40                   | inc                 eax
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   8b45c0               | mov                 eax, dword ptr [ebp - 0x40]
            //   83c008               | add                 eax, 8
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]

        $sequence_21 = { 8b45a0 05c8d45566 7440 c745880a000000 eb07 8b4588 }
            // n = 6, score = 100
            //   8b45a0               | mov                 eax, dword ptr [ebp - 0x60]
            //   05c8d45566           | add                 eax, 0x6655d4c8
            //   7440                 | je                  0x42
            //   c745880a000000       | mov                 dword ptr [ebp - 0x78], 0xa
            //   eb07                 | jmp                 9
            //   8b4588               | mov                 eax, dword ptr [ebp - 0x78]

        $sequence_22 = { 55 08709e 891f 3e50 }
            // n = 4, score = 100
            //   55                   | push                ebp
            //   08709e               | or                  byte ptr [eax - 0x62], dh
            //   891f                 | mov                 dword ptr [edi], ebx
            //   3e50                 | push                eax

        $sequence_23 = { 2345e4 8945d8 c645f300 c645fc65 }
            // n = 4, score = 100
            //   2345e4               | and                 eax, dword ptr [ebp - 0x1c]
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   c645f300             | mov                 byte ptr [ebp - 0xd], 0
            //   c645fc65             | mov                 byte ptr [ebp - 4], 0x65

        $sequence_24 = { a1???????? 8945b4 a1???????? 83c044 a3???????? }
            // n = 5, score = 100
            //   a1????????           |                     
            //   8945b4               | mov                 dword ptr [ebp - 0x4c], eax
            //   a1????????           |                     
            //   83c044               | add                 eax, 0x44
            //   a3????????           |                     

        $sequence_25 = { 8b45b4 83e803 8945b4 eb22 }
            // n = 4, score = 100
            //   8b45b4               | mov                 eax, dword ptr [ebp - 0x4c]
            //   83e803               | sub                 eax, 3
            //   8945b4               | mov                 dword ptr [ebp - 0x4c], eax
            //   eb22                 | jmp                 0x24

        $sequence_26 = { 0305???????? a3???????? a1???????? 0faf45bc a3???????? ebc5 8365d400 }
            // n = 7, score = 100
            //   0305????????         |                     
            //   a3????????           |                     
            //   a1????????           |                     
            //   0faf45bc             | imul                eax, dword ptr [ebp - 0x44]
            //   a3????????           |                     
            //   ebc5                 | jmp                 0xffffffc7
            //   8365d400             | and                 dword ptr [ebp - 0x2c], 0

    condition:
        7 of them and filesize < 106496
}