rule win_hardrain_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hardrain."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hardrain"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83ec0c 8b4c2414 8b442410 56 57 8b7904 8b7004 }
            // n = 7, score = 200
            //   83ec0c               | sub                 esp, 0xc
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7904               | mov                 edi, dword ptr [ecx + 4]
            //   8b7004               | mov                 esi, dword ptr [eax + 4]

        $sequence_1 = { 5e 81c418010000 c20400 83ec0c }
            // n = 4, score = 200
            //   5e                   | pop                 esi
            //   81c418010000         | add                 esp, 0x118
            //   c20400               | ret                 4
            //   83ec0c               | sub                 esp, 0xc

        $sequence_2 = { 83ec10 56 57 8b7c241c 6685ff }
            // n = 5, score = 200
            //   83ec10               | sub                 esp, 0x10
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7c241c             | mov                 edi, dword ptr [esp + 0x1c]
            //   6685ff               | test                di, di

        $sequence_3 = { 52 e8???????? 33c0 b910000000 89442448 }
            // n = 5, score = 200
            //   52                   | push                edx
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   b910000000           | mov                 ecx, 0x10
            //   89442448             | mov                 dword ptr [esp + 0x48], eax

        $sequence_4 = { 5e 83c418 c3 33c9 33c0 8b542424 894c2410 }
            // n = 7, score = 200
            //   5e                   | pop                 esi
            //   83c418               | add                 esp, 0x18
            //   c3                   | ret                 
            //   33c9                 | xor                 ecx, ecx
            //   33c0                 | xor                 eax, eax
            //   8b542424             | mov                 edx, dword ptr [esp + 0x24]
            //   894c2410             | mov                 dword ptr [esp + 0x10], ecx

        $sequence_5 = { c3 68ffffff7f 56 ff15???????? 85c0 }
            // n = 5, score = 200
            //   c3                   | ret                 
            //   68ffffff7f           | push                0x7fffffff
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_6 = { 32d0 88143e 46 3bf3 7cea 5f 8d4c2408 }
            // n = 7, score = 200
            //   32d0                 | xor                 dl, al
            //   88143e               | mov                 byte ptr [esi + edi], dl
            //   46                   | inc                 esi
            //   3bf3                 | cmp                 esi, ebx
            //   7cea                 | jl                  0xffffffec
            //   5f                   | pop                 edi
            //   8d4c2408             | lea                 ecx, [esp + 8]

        $sequence_7 = { 52 8bce e8???????? 85c0 7413 6a16 8d44241c }
            // n = 7, score = 200
            //   52                   | push                edx
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7413                 | je                  0x15
            //   6a16                 | push                0x16
            //   8d44241c             | lea                 eax, [esp + 0x1c]

        $sequence_8 = { e8???????? 50 8bce e8???????? 85c0 0f84da000000 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f84da000000         | je                  0xe0

        $sequence_9 = { 5d b801000000 5b 59 c20400 8b4c2410 895910 }
            // n = 7, score = 200
            //   5d                   | pop                 ebp
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx
            //   59                   | pop                 ecx
            //   c20400               | ret                 4
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   895910               | mov                 dword ptr [ecx + 0x10], ebx

    condition:
        7 of them and filesize < 368640
}